// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceGetChannelReader is a Reader for the PackerServiceGetChannel structure.
type PackerServiceGetChannelReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceGetChannelReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceGetChannelOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceGetChannelDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceGetChannelOK creates a PackerServiceGetChannelOK with default headers values
func NewPackerServiceGetChannelOK() *PackerServiceGetChannelOK {
	return &PackerServiceGetChannelOK{}
}

/*
PackerServiceGetChannelOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceGetChannelOK struct {
	Payload *models.HashicorpCloudPacker20230101GetChannelResponse
}

// IsSuccess returns true when this packer service get channel o k response has a 2xx status code
func (o *PackerServiceGetChannelOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service get channel o k response has a 3xx status code
func (o *PackerServiceGetChannelOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service get channel o k response has a 4xx status code
func (o *PackerServiceGetChannelOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service get channel o k response has a 5xx status code
func (o *PackerServiceGetChannelOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service get channel o k response a status code equal to that given
func (o *PackerServiceGetChannelOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service get channel o k response
func (o *PackerServiceGetChannelOK) Code() int {
	return 200
}

func (o *PackerServiceGetChannelOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}][%d] packerServiceGetChannelOK %s", 200, payload)
}

func (o *PackerServiceGetChannelOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}][%d] packerServiceGetChannelOK %s", 200, payload)
}

func (o *PackerServiceGetChannelOK) GetPayload() *models.HashicorpCloudPacker20230101GetChannelResponse {
	return o.Payload
}

func (o *PackerServiceGetChannelOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101GetChannelResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceGetChannelDefault creates a PackerServiceGetChannelDefault with default headers values
func NewPackerServiceGetChannelDefault(code int) *PackerServiceGetChannelDefault {
	return &PackerServiceGetChannelDefault{
		_statusCode: code,
	}
}

/*
PackerServiceGetChannelDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceGetChannelDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service get channel default response has a 2xx status code
func (o *PackerServiceGetChannelDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service get channel default response has a 3xx status code
func (o *PackerServiceGetChannelDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service get channel default response has a 4xx status code
func (o *PackerServiceGetChannelDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service get channel default response has a 5xx status code
func (o *PackerServiceGetChannelDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service get channel default response a status code equal to that given
func (o *PackerServiceGetChannelDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service get channel default response
func (o *PackerServiceGetChannelDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceGetChannelDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}][%d] PackerService_GetChannel default %s", o._statusCode, payload)
}

func (o *PackerServiceGetChannelDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/channels/{channel_name}][%d] PackerService_GetChannel default %s", o._statusCode, payload)
}

func (o *PackerServiceGetChannelDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceGetChannelDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
