// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceListSbomsReader is a Reader for the PackerServiceListSboms structure.
type PackerServiceListSbomsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceListSbomsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceListSbomsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceListSbomsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceListSbomsOK creates a PackerServiceListSbomsOK with default headers values
func NewPackerServiceListSbomsOK() *PackerServiceListSbomsOK {
	return &PackerServiceListSbomsOK{}
}

/*
PackerServiceListSbomsOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceListSbomsOK struct {
	Payload *models.HashicorpCloudPacker20230101ListSbomsResponse
}

// IsSuccess returns true when this packer service list sboms o k response has a 2xx status code
func (o *PackerServiceListSbomsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service list sboms o k response has a 3xx status code
func (o *PackerServiceListSbomsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service list sboms o k response has a 4xx status code
func (o *PackerServiceListSbomsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service list sboms o k response has a 5xx status code
func (o *PackerServiceListSbomsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service list sboms o k response a status code equal to that given
func (o *PackerServiceListSbomsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service list sboms o k response
func (o *PackerServiceListSbomsOK) Code() int {
	return 200
}

func (o *PackerServiceListSbomsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms][%d] packerServiceListSbomsOK %s", 200, payload)
}

func (o *PackerServiceListSbomsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms][%d] packerServiceListSbomsOK %s", 200, payload)
}

func (o *PackerServiceListSbomsOK) GetPayload() *models.HashicorpCloudPacker20230101ListSbomsResponse {
	return o.Payload
}

func (o *PackerServiceListSbomsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101ListSbomsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceListSbomsDefault creates a PackerServiceListSbomsDefault with default headers values
func NewPackerServiceListSbomsDefault(code int) *PackerServiceListSbomsDefault {
	return &PackerServiceListSbomsDefault{
		_statusCode: code,
	}
}

/*
PackerServiceListSbomsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceListSbomsDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service list sboms default response has a 2xx status code
func (o *PackerServiceListSbomsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service list sboms default response has a 3xx status code
func (o *PackerServiceListSbomsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service list sboms default response has a 4xx status code
func (o *PackerServiceListSbomsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service list sboms default response has a 5xx status code
func (o *PackerServiceListSbomsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service list sboms default response a status code equal to that given
func (o *PackerServiceListSbomsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service list sboms default response
func (o *PackerServiceListSbomsDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceListSbomsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms][%d] PackerService_ListSboms default %s", o._statusCode, payload)
}

func (o *PackerServiceListSbomsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms][%d] PackerService_ListSboms default %s", o._statusCode, payload)
}

func (o *PackerServiceListSbomsDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceListSbomsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
