// Code generated by go-swagger; DO NOT EDIT.

package authorization_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new authorization service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new authorization service API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new authorization service API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for authorization service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AuthorizationServiceBatchTestIamPermissions(params *AuthorizationServiceBatchTestIamPermissionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuthorizationServiceBatchTestIamPermissionsOK, error)

	AuthorizationServiceTestIamPermissions(params *AuthorizationServiceTestIamPermissionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuthorizationServiceTestIamPermissionsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
AuthorizationServiceBatchTestIamPermissions batches test iam permissions allows for a batch of test iam permissions requests to be made in a single call
*/
func (a *Client) AuthorizationServiceBatchTestIamPermissions(params *AuthorizationServiceBatchTestIamPermissionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuthorizationServiceBatchTestIamPermissionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuthorizationServiceBatchTestIamPermissionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AuthorizationService_BatchTestIamPermissions",
		Method:             "POST",
		PathPattern:        "/resource-manager/2019-12-10/authorization/batch-test-iam-permissions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &AuthorizationServiceBatchTestIamPermissionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AuthorizationServiceBatchTestIamPermissionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuthorizationServiceBatchTestIamPermissionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
AuthorizationServiceTestIamPermissions tests iam permissions returns a subset of the request permissions the calling principal has for the authorization context
*/
func (a *Client) AuthorizationServiceTestIamPermissions(params *AuthorizationServiceTestIamPermissionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AuthorizationServiceTestIamPermissionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAuthorizationServiceTestIamPermissionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "AuthorizationService_TestIamPermissions",
		Method:             "POST",
		PathPattern:        "/resource-manager/2019-12-10/authorization/test-iam-permissions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &AuthorizationServiceTestIamPermissionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AuthorizationServiceTestIamPermissionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AuthorizationServiceTestIamPermissionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
