// Code generated by go-swagger; DO NOT EDIT.

package resource_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewResourceServiceGetIamPolicyParams creates a new ResourceServiceGetIamPolicyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewResourceServiceGetIamPolicyParams() *ResourceServiceGetIamPolicyParams {
	return &ResourceServiceGetIamPolicyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewResourceServiceGetIamPolicyParamsWithTimeout creates a new ResourceServiceGetIamPolicyParams object
// with the ability to set a timeout on a request.
func NewResourceServiceGetIamPolicyParamsWithTimeout(timeout time.Duration) *ResourceServiceGetIamPolicyParams {
	return &ResourceServiceGetIamPolicyParams{
		timeout: timeout,
	}
}

// NewResourceServiceGetIamPolicyParamsWithContext creates a new ResourceServiceGetIamPolicyParams object
// with the ability to set a context for a request.
func NewResourceServiceGetIamPolicyParamsWithContext(ctx context.Context) *ResourceServiceGetIamPolicyParams {
	return &ResourceServiceGetIamPolicyParams{
		Context: ctx,
	}
}

// NewResourceServiceGetIamPolicyParamsWithHTTPClient creates a new ResourceServiceGetIamPolicyParams object
// with the ability to set a custom HTTPClient for a request.
func NewResourceServiceGetIamPolicyParamsWithHTTPClient(client *http.Client) *ResourceServiceGetIamPolicyParams {
	return &ResourceServiceGetIamPolicyParams{
		HTTPClient: client,
	}
}

/*
ResourceServiceGetIamPolicyParams contains all the parameters to send to the API endpoint

	for the resource service get iam policy operation.

	Typically these are written to a http.Request.
*/
type ResourceServiceGetIamPolicyParams struct {

	/* ResourceID.

	   ResourceId is the resource name of the resource. Either this or the ResourceName needs to be provided.
	*/
	ResourceID *string

	/* ResourceName.

	   ResourceName is the resource name of the resource. Either this or the ResourceId needs to be provided.
	*/
	ResourceName *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the resource service get iam policy params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceServiceGetIamPolicyParams) WithDefaults() *ResourceServiceGetIamPolicyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the resource service get iam policy params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceServiceGetIamPolicyParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the resource service get iam policy params
func (o *ResourceServiceGetIamPolicyParams) WithTimeout(timeout time.Duration) *ResourceServiceGetIamPolicyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the resource service get iam policy params
func (o *ResourceServiceGetIamPolicyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the resource service get iam policy params
func (o *ResourceServiceGetIamPolicyParams) WithContext(ctx context.Context) *ResourceServiceGetIamPolicyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the resource service get iam policy params
func (o *ResourceServiceGetIamPolicyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the resource service get iam policy params
func (o *ResourceServiceGetIamPolicyParams) WithHTTPClient(client *http.Client) *ResourceServiceGetIamPolicyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the resource service get iam policy params
func (o *ResourceServiceGetIamPolicyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithResourceID adds the resourceID to the resource service get iam policy params
func (o *ResourceServiceGetIamPolicyParams) WithResourceID(resourceID *string) *ResourceServiceGetIamPolicyParams {
	o.SetResourceID(resourceID)
	return o
}

// SetResourceID adds the resourceId to the resource service get iam policy params
func (o *ResourceServiceGetIamPolicyParams) SetResourceID(resourceID *string) {
	o.ResourceID = resourceID
}

// WithResourceName adds the resourceName to the resource service get iam policy params
func (o *ResourceServiceGetIamPolicyParams) WithResourceName(resourceName *string) *ResourceServiceGetIamPolicyParams {
	o.SetResourceName(resourceName)
	return o
}

// SetResourceName adds the resourceName to the resource service get iam policy params
func (o *ResourceServiceGetIamPolicyParams) SetResourceName(resourceName *string) {
	o.ResourceName = resourceName
}

// WriteToRequest writes these params to a swagger request
func (o *ResourceServiceGetIamPolicyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ResourceID != nil {

		// query param resource_id
		var qrResourceID string

		if o.ResourceID != nil {
			qrResourceID = *o.ResourceID
		}
		qResourceID := qrResourceID
		if qResourceID != "" {

			if err := r.SetQueryParam("resource_id", qResourceID); err != nil {
				return err
			}
		}
	}

	if o.ResourceName != nil {

		// query param resource_name
		var qrResourceName string

		if o.ResourceName != nil {
			qrResourceName = *o.ResourceName
		}
		qResourceName := qrResourceName
		if qResourceName != "" {

			if err := r.SetQueryParam("resource_name", qResourceName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
