// Code generated by go-swagger; DO NOT EDIT.

package resource_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ResourceServiceListAccessibleResourcesReader is a Reader for the ResourceServiceListAccessibleResources structure.
type ResourceServiceListAccessibleResourcesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ResourceServiceListAccessibleResourcesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewResourceServiceListAccessibleResourcesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewResourceServiceListAccessibleResourcesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewResourceServiceListAccessibleResourcesOK creates a ResourceServiceListAccessibleResourcesOK with default headers values
func NewResourceServiceListAccessibleResourcesOK() *ResourceServiceListAccessibleResourcesOK {
	return &ResourceServiceListAccessibleResourcesOK{}
}

/*
ResourceServiceListAccessibleResourcesOK describes a response with status code 200, with default header values.

A successful response.
*/
type ResourceServiceListAccessibleResourcesOK struct {
	Payload *models.HashicorpCloudResourcemanagerResourceListAccessibleResourcesResponse
}

// IsSuccess returns true when this resource service list accessible resources o k response has a 2xx status code
func (o *ResourceServiceListAccessibleResourcesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this resource service list accessible resources o k response has a 3xx status code
func (o *ResourceServiceListAccessibleResourcesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this resource service list accessible resources o k response has a 4xx status code
func (o *ResourceServiceListAccessibleResourcesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this resource service list accessible resources o k response has a 5xx status code
func (o *ResourceServiceListAccessibleResourcesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this resource service list accessible resources o k response a status code equal to that given
func (o *ResourceServiceListAccessibleResourcesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the resource service list accessible resources o k response
func (o *ResourceServiceListAccessibleResourcesOK) Code() int {
	return 200
}

func (o *ResourceServiceListAccessibleResourcesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/resources/accessible][%d] resourceServiceListAccessibleResourcesOK %s", 200, payload)
}

func (o *ResourceServiceListAccessibleResourcesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/resources/accessible][%d] resourceServiceListAccessibleResourcesOK %s", 200, payload)
}

func (o *ResourceServiceListAccessibleResourcesOK) GetPayload() *models.HashicorpCloudResourcemanagerResourceListAccessibleResourcesResponse {
	return o.Payload
}

func (o *ResourceServiceListAccessibleResourcesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudResourcemanagerResourceListAccessibleResourcesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewResourceServiceListAccessibleResourcesDefault creates a ResourceServiceListAccessibleResourcesDefault with default headers values
func NewResourceServiceListAccessibleResourcesDefault(code int) *ResourceServiceListAccessibleResourcesDefault {
	return &ResourceServiceListAccessibleResourcesDefault{
		_statusCode: code,
	}
}

/*
ResourceServiceListAccessibleResourcesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ResourceServiceListAccessibleResourcesDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this resource service list accessible resources default response has a 2xx status code
func (o *ResourceServiceListAccessibleResourcesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this resource service list accessible resources default response has a 3xx status code
func (o *ResourceServiceListAccessibleResourcesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this resource service list accessible resources default response has a 4xx status code
func (o *ResourceServiceListAccessibleResourcesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this resource service list accessible resources default response has a 5xx status code
func (o *ResourceServiceListAccessibleResourcesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this resource service list accessible resources default response a status code equal to that given
func (o *ResourceServiceListAccessibleResourcesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the resource service list accessible resources default response
func (o *ResourceServiceListAccessibleResourcesDefault) Code() int {
	return o._statusCode
}

func (o *ResourceServiceListAccessibleResourcesDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/resources/accessible][%d] ResourceService_ListAccessibleResources default %s", o._statusCode, payload)
}

func (o *ResourceServiceListAccessibleResourcesDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/resources/accessible][%d] ResourceService_ListAccessibleResources default %s", o._statusCode, payload)
}

func (o *ResourceServiceListAccessibleResourcesDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ResourceServiceListAccessibleResourcesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
