// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListVersionsParams creates a new ListVersionsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListVersionsParams() *ListVersionsParams {
	return &ListVersionsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListVersionsParamsWithTimeout creates a new ListVersionsParams object
// with the ability to set a timeout on a request.
func NewListVersionsParamsWithTimeout(timeout time.Duration) *ListVersionsParams {
	return &ListVersionsParams{
		timeout: timeout,
	}
}

// NewListVersionsParamsWithContext creates a new ListVersionsParams object
// with the ability to set a context for a request.
func NewListVersionsParamsWithContext(ctx context.Context) *ListVersionsParams {
	return &ListVersionsParams{
		Context: ctx,
	}
}

// NewListVersionsParamsWithHTTPClient creates a new ListVersionsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListVersionsParamsWithHTTPClient(client *http.Client) *ListVersionsParams {
	return &ListVersionsParams{
		HTTPClient: client,
	}
}

/*
ListVersionsParams contains all the parameters to send to the API endpoint

	for the list versions operation.

	Typically these are written to a http.Request.
*/
type ListVersionsParams struct {

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Expanded.

	   Expand the version child elements.
	*/
	Expanded *bool

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list versions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListVersionsParams) WithDefaults() *ListVersionsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list versions params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListVersionsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list versions params
func (o *ListVersionsParams) WithTimeout(timeout time.Duration) *ListVersionsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list versions params
func (o *ListVersionsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list versions params
func (o *ListVersionsParams) WithContext(ctx context.Context) *ListVersionsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list versions params
func (o *ListVersionsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list versions params
func (o *ListVersionsParams) WithHTTPClient(client *http.Client) *ListVersionsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list versions params
func (o *ListVersionsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBox adds the box to the list versions params
func (o *ListVersionsParams) WithBox(box string) *ListVersionsParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the list versions params
func (o *ListVersionsParams) SetBox(box string) {
	o.Box = box
}

// WithExpanded adds the expanded to the list versions params
func (o *ListVersionsParams) WithExpanded(expanded *bool) *ListVersionsParams {
	o.SetExpanded(expanded)
	return o
}

// SetExpanded adds the expanded to the list versions params
func (o *ListVersionsParams) SetExpanded(expanded *bool) {
	o.Expanded = expanded
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the list versions params
func (o *ListVersionsParams) WithPaginationNextPageToken(paginationNextPageToken *string) *ListVersionsParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the list versions params
func (o *ListVersionsParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the list versions params
func (o *ListVersionsParams) WithPaginationPageSize(paginationPageSize *int64) *ListVersionsParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the list versions params
func (o *ListVersionsParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the list versions params
func (o *ListVersionsParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *ListVersionsParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the list versions params
func (o *ListVersionsParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithRegistry adds the registry to the list versions params
func (o *ListVersionsParams) WithRegistry(registry string) *ListVersionsParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the list versions params
func (o *ListVersionsParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WriteToRequest writes these params to a swagger request
func (o *ListVersionsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	if o.Expanded != nil {

		// query param expanded
		var qrExpanded bool

		if o.Expanded != nil {
			qrExpanded = *o.Expanded
		}
		qExpanded := swag.FormatBool(qrExpanded)
		if qExpanded != "" {

			if err := r.SetQueryParam("expanded", qExpanded); err != nil {
				return err
			}
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
