// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vagrant-box-registry/stable/2022-09-30/models"
)

// RevokeVersionReader is a Reader for the RevokeVersion structure.
type RevokeVersionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *RevokeVersionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewRevokeVersionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewRevokeVersionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewRevokeVersionOK creates a RevokeVersionOK with default headers values
func NewRevokeVersionOK() *RevokeVersionOK {
	return &RevokeVersionOK{}
}

/*
RevokeVersionOK describes a response with status code 200, with default header values.

A successful response.
*/
type RevokeVersionOK struct {
	Payload models.HashicorpCloudVagrant20220930RevokeVersionResponse
}

// IsSuccess returns true when this revoke version o k response has a 2xx status code
func (o *RevokeVersionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this revoke version o k response has a 3xx status code
func (o *RevokeVersionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this revoke version o k response has a 4xx status code
func (o *RevokeVersionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this revoke version o k response has a 5xx status code
func (o *RevokeVersionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this revoke version o k response a status code equal to that given
func (o *RevokeVersionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the revoke version o k response
func (o *RevokeVersionOK) Code() int {
	return 200
}

func (o *RevokeVersionOK) Error() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/revoke][%d] revokeVersionOK  %+v", 200, o.Payload)
}

func (o *RevokeVersionOK) String() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/revoke][%d] revokeVersionOK  %+v", 200, o.Payload)
}

func (o *RevokeVersionOK) GetPayload() models.HashicorpCloudVagrant20220930RevokeVersionResponse {
	return o.Payload
}

func (o *RevokeVersionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewRevokeVersionDefault creates a RevokeVersionDefault with default headers values
func NewRevokeVersionDefault(code int) *RevokeVersionDefault {
	return &RevokeVersionDefault{
		_statusCode: code,
	}
}

/*
RevokeVersionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type RevokeVersionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this revoke version default response has a 2xx status code
func (o *RevokeVersionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this revoke version default response has a 3xx status code
func (o *RevokeVersionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this revoke version default response has a 4xx status code
func (o *RevokeVersionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this revoke version default response has a 5xx status code
func (o *RevokeVersionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this revoke version default response a status code equal to that given
func (o *RevokeVersionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the revoke version default response
func (o *RevokeVersionDefault) Code() int {
	return o._statusCode
}

func (o *RevokeVersionDefault) Error() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/revoke][%d] RevokeVersion default  %+v", o._statusCode, o.Payload)
}

func (o *RevokeVersionDefault) String() string {
	return fmt.Sprintf("[PUT /vagrant/2022-09-30/registry/{registry}/box/{box}/version/{version}/revoke][%d] RevokeVersion default  %+v", o._statusCode, o.Payload)
}

func (o *RevokeVersionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *RevokeVersionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
