// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewUploadBoxParams creates a new UploadBoxParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUploadBoxParams() *UploadBoxParams {
	return &UploadBoxParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUploadBoxParamsWithTimeout creates a new UploadBoxParams object
// with the ability to set a timeout on a request.
func NewUploadBoxParamsWithTimeout(timeout time.Duration) *UploadBoxParams {
	return &UploadBoxParams{
		timeout: timeout,
	}
}

// NewUploadBoxParamsWithContext creates a new UploadBoxParams object
// with the ability to set a context for a request.
func NewUploadBoxParamsWithContext(ctx context.Context) *UploadBoxParams {
	return &UploadBoxParams{
		Context: ctx,
	}
}

// NewUploadBoxParamsWithHTTPClient creates a new UploadBoxParams object
// with the ability to set a custom HTTPClient for a request.
func NewUploadBoxParamsWithHTTPClient(client *http.Client) *UploadBoxParams {
	return &UploadBoxParams{
		HTTPClient: client,
	}
}

/*
UploadBoxParams contains all the parameters to send to the API endpoint

	for the upload box operation.

	Typically these are written to a http.Request.
*/
type UploadBoxParams struct {

	/* Architecture.

	   The type of the Architecture.
	*/
	Architecture string

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Provider.

	   The name of the Provider.
	*/
	Provider string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version for the Provider.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the upload box params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UploadBoxParams) WithDefaults() *UploadBoxParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the upload box params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UploadBoxParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the upload box params
func (o *UploadBoxParams) WithTimeout(timeout time.Duration) *UploadBoxParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the upload box params
func (o *UploadBoxParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the upload box params
func (o *UploadBoxParams) WithContext(ctx context.Context) *UploadBoxParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the upload box params
func (o *UploadBoxParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the upload box params
func (o *UploadBoxParams) WithHTTPClient(client *http.Client) *UploadBoxParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the upload box params
func (o *UploadBoxParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithArchitecture adds the architecture to the upload box params
func (o *UploadBoxParams) WithArchitecture(architecture string) *UploadBoxParams {
	o.SetArchitecture(architecture)
	return o
}

// SetArchitecture adds the architecture to the upload box params
func (o *UploadBoxParams) SetArchitecture(architecture string) {
	o.Architecture = architecture
}

// WithBox adds the box to the upload box params
func (o *UploadBoxParams) WithBox(box string) *UploadBoxParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the upload box params
func (o *UploadBoxParams) SetBox(box string) {
	o.Box = box
}

// WithProvider adds the provider to the upload box params
func (o *UploadBoxParams) WithProvider(provider string) *UploadBoxParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the upload box params
func (o *UploadBoxParams) SetProvider(provider string) {
	o.Provider = provider
}

// WithRegistry adds the registry to the upload box params
func (o *UploadBoxParams) WithRegistry(registry string) *UploadBoxParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the upload box params
func (o *UploadBoxParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the upload box params
func (o *UploadBoxParams) WithVersion(version string) *UploadBoxParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the upload box params
func (o *UploadBoxParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *UploadBoxParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param architecture
	if err := r.SetPathParam("architecture", o.Architecture); err != nil {
		return err
	}

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
