// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// HashicorpCloudVagrant20220930Registry hashicorp cloud vagrant 20220930 registry
//
// swagger:model hashicorp.cloud.vagrant_20220930.Registry
type HashicorpCloudVagrant20220930Registry struct {

	// Whether or not the Registry is currently activated.
	// Read Only: true
	Activated *bool `json:"activated,omitempty"`

	// Boxes of registry (if expanded).
	// Read Only: true
	Boxes []*HashicorpCloudVagrant20220930Box `json:"boxes"`

	// The date the record was created.
	// Read Only: true
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// The description of the registry, if it exists.
	Description string `json:"description,omitempty"`

	// The HTML rendered description
	// Read Only: true
	DescriptionHTML string `json:"description_html,omitempty"`

	// The gravatar used for this registry
	// Read Only: true
	GravatarURL string `json:"gravatar_url,omitempty"`

	// The Location that the Registry resides in.
	Location *cloud.HashicorpCloudLocationLocation `json:"location,omitempty"`

	// The name of the Registry. This is a user-settable, globally-unique name,
	// and forms the first segment of a box, ie: the "hashicorp" in
	// "hashicorp/vagrant". No two registries can have the same name, regardless
	// of the location (org/project) they are in.
	Name string `json:"name,omitempty"`

	// The date that the record was last updated.
	// Read Only: true
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud vagrant 20220930 registry
func (m *HashicorpCloudVagrant20220930Registry) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBoxes(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrant20220930Registry) validateBoxes(formats strfmt.Registry) error {
	if swag.IsZero(m.Boxes) { // not required
		return nil
	}

	for i := 0; i < len(m.Boxes); i++ {
		if swag.IsZero(m.Boxes[i]) { // not required
			continue
		}

		if m.Boxes[i] != nil {
			if err := m.Boxes[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("boxes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("boxes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Registry) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Registry) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(m.Location) { // not required
		return nil
	}

	if m.Location != nil {
		if err := m.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Registry) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud vagrant 20220930 registry based on the context it is used
func (m *HashicorpCloudVagrant20220930Registry) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActivated(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateBoxes(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateCreatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDescriptionHTML(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateGravatarURL(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUpdatedAt(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrant20220930Registry) contextValidateActivated(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "activated", "body", m.Activated); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Registry) contextValidateBoxes(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "boxes", "body", []*HashicorpCloudVagrant20220930Box(m.Boxes)); err != nil {
		return err
	}

	for i := 0; i < len(m.Boxes); i++ {

		if m.Boxes[i] != nil {

			if swag.IsZero(m.Boxes[i]) { // not required
				return nil
			}

			if err := m.Boxes[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("boxes" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("boxes" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Registry) contextValidateCreatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "created_at", "body", strfmt.DateTime(m.CreatedAt)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Registry) contextValidateDescriptionHTML(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "description_html", "body", string(m.DescriptionHTML)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Registry) contextValidateGravatarURL(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "gravatar_url", "body", string(m.GravatarURL)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Registry) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if m.Location != nil {

		if swag.IsZero(m.Location) { // not required
			return nil
		}

		if err := m.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("location")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudVagrant20220930Registry) contextValidateUpdatedAt(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "updated_at", "body", strfmt.DateTime(m.UpdatedAt)); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudVagrant20220930Registry) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudVagrant20220930Registry) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudVagrant20220930Registry
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
