// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// CreateGhOrgSyncIntegrationReader is a Reader for the CreateGhOrgSyncIntegration structure.
type CreateGhOrgSyncIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateGhOrgSyncIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateGhOrgSyncIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateGhOrgSyncIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateGhOrgSyncIntegrationOK creates a CreateGhOrgSyncIntegrationOK with default headers values
func NewCreateGhOrgSyncIntegrationOK() *CreateGhOrgSyncIntegrationOK {
	return &CreateGhOrgSyncIntegrationOK{}
}

/*
CreateGhOrgSyncIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateGhOrgSyncIntegrationOK struct {
	Payload *models.Secrets20230613CreateSyncIntegrationResponse
}

// IsSuccess returns true when this create gh org sync integration o k response has a 2xx status code
func (o *CreateGhOrgSyncIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create gh org sync integration o k response has a 3xx status code
func (o *CreateGhOrgSyncIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create gh org sync integration o k response has a 4xx status code
func (o *CreateGhOrgSyncIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create gh org sync integration o k response has a 5xx status code
func (o *CreateGhOrgSyncIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create gh org sync integration o k response a status code equal to that given
func (o *CreateGhOrgSyncIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create gh org sync integration o k response
func (o *CreateGhOrgSyncIntegrationOK) Code() int {
	return 200
}

func (o *CreateGhOrgSyncIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gh-org][%d] createGhOrgSyncIntegrationOK %s", 200, payload)
}

func (o *CreateGhOrgSyncIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gh-org][%d] createGhOrgSyncIntegrationOK %s", 200, payload)
}

func (o *CreateGhOrgSyncIntegrationOK) GetPayload() *models.Secrets20230613CreateSyncIntegrationResponse {
	return o.Payload
}

func (o *CreateGhOrgSyncIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20230613CreateSyncIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateGhOrgSyncIntegrationDefault creates a CreateGhOrgSyncIntegrationDefault with default headers values
func NewCreateGhOrgSyncIntegrationDefault(code int) *CreateGhOrgSyncIntegrationDefault {
	return &CreateGhOrgSyncIntegrationDefault{
		_statusCode: code,
	}
}

/*
CreateGhOrgSyncIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateGhOrgSyncIntegrationDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this create gh org sync integration default response has a 2xx status code
func (o *CreateGhOrgSyncIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create gh org sync integration default response has a 3xx status code
func (o *CreateGhOrgSyncIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create gh org sync integration default response has a 4xx status code
func (o *CreateGhOrgSyncIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create gh org sync integration default response has a 5xx status code
func (o *CreateGhOrgSyncIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create gh org sync integration default response a status code equal to that given
func (o *CreateGhOrgSyncIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create gh org sync integration default response
func (o *CreateGhOrgSyncIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *CreateGhOrgSyncIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gh-org][%d] CreateGhOrgSyncIntegration default %s", o._statusCode, payload)
}

func (o *CreateGhOrgSyncIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gh-org][%d] CreateGhOrgSyncIntegration default %s", o._statusCode, payload)
}

func (o *CreateGhOrgSyncIntegrationDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *CreateGhOrgSyncIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CreateGhOrgSyncIntegrationBody create gh org sync integration body
swagger:model CreateGhOrgSyncIntegrationBody
*/
type CreateGhOrgSyncIntegrationBody struct {

	// gh org connection details
	GhOrgConnectionDetails *models.Secrets20230613GhOrgConnectionDetailsRequest `json:"gh_org_connection_details,omitempty"`

	// location
	Location *CreateGhOrgSyncIntegrationParamsBodyLocation `json:"location,omitempty"`

	// name
	Name string `json:"name,omitempty"`
}

// Validate validates this create gh org sync integration body
func (o *CreateGhOrgSyncIntegrationBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateGhOrgConnectionDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateGhOrgSyncIntegrationBody) validateGhOrgConnectionDetails(formats strfmt.Registry) error {
	if swag.IsZero(o.GhOrgConnectionDetails) { // not required
		return nil
	}

	if o.GhOrgConnectionDetails != nil {
		if err := o.GhOrgConnectionDetails.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "gh_org_connection_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "gh_org_connection_details")
			}
			return err
		}
	}

	return nil
}

func (o *CreateGhOrgSyncIntegrationBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create gh org sync integration body based on the context it is used
func (o *CreateGhOrgSyncIntegrationBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateGhOrgConnectionDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateGhOrgSyncIntegrationBody) contextValidateGhOrgConnectionDetails(ctx context.Context, formats strfmt.Registry) error {

	if o.GhOrgConnectionDetails != nil {

		if swag.IsZero(o.GhOrgConnectionDetails) { // not required
			return nil
		}

		if err := o.GhOrgConnectionDetails.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "gh_org_connection_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "gh_org_connection_details")
			}
			return err
		}
	}

	return nil
}

func (o *CreateGhOrgSyncIntegrationBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateGhOrgSyncIntegrationBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateGhOrgSyncIntegrationBody) UnmarshalBinary(b []byte) error {
	var res CreateGhOrgSyncIntegrationBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CreateGhOrgSyncIntegrationParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model CreateGhOrgSyncIntegrationParamsBodyLocation
*/
type CreateGhOrgSyncIntegrationParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this create gh org sync integration params body location
func (o *CreateGhOrgSyncIntegrationParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateGhOrgSyncIntegrationParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create gh org sync integration params body location based on the context it is used
func (o *CreateGhOrgSyncIntegrationParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateGhOrgSyncIntegrationParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateGhOrgSyncIntegrationParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateGhOrgSyncIntegrationParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res CreateGhOrgSyncIntegrationParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
