// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewListAppsParams creates a new ListAppsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListAppsParams() *ListAppsParams {
	return &ListAppsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListAppsParamsWithTimeout creates a new ListAppsParams object
// with the ability to set a timeout on a request.
func NewListAppsParamsWithTimeout(timeout time.Duration) *ListAppsParams {
	return &ListAppsParams{
		timeout: timeout,
	}
}

// NewListAppsParamsWithContext creates a new ListAppsParams object
// with the ability to set a context for a request.
func NewListAppsParamsWithContext(ctx context.Context) *ListAppsParams {
	return &ListAppsParams{
		Context: ctx,
	}
}

// NewListAppsParamsWithHTTPClient creates a new ListAppsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListAppsParamsWithHTTPClient(client *http.Client) *ListAppsParams {
	return &ListAppsParams{
		HTTPClient: client,
	}
}

/*
ListAppsParams contains all the parameters to send to the API endpoint

	for the list apps operation.

	Typically these are written to a http.Request.
*/
type ListAppsParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list apps params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListAppsParams) WithDefaults() *ListAppsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list apps params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListAppsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list apps params
func (o *ListAppsParams) WithTimeout(timeout time.Duration) *ListAppsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list apps params
func (o *ListAppsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list apps params
func (o *ListAppsParams) WithContext(ctx context.Context) *ListAppsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list apps params
func (o *ListAppsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list apps params
func (o *ListAppsParams) WithHTTPClient(client *http.Client) *ListAppsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list apps params
func (o *ListAppsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the list apps params
func (o *ListAppsParams) WithLocationOrganizationID(locationOrganizationID string) *ListAppsParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the list apps params
func (o *ListAppsParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the list apps params
func (o *ListAppsParams) WithLocationProjectID(locationProjectID string) *ListAppsParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the list apps params
func (o *ListAppsParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the list apps params
func (o *ListAppsParams) WithLocationRegionProvider(locationRegionProvider *string) *ListAppsParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the list apps params
func (o *ListAppsParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the list apps params
func (o *ListAppsParams) WithLocationRegionRegion(locationRegionRegion *string) *ListAppsParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the list apps params
func (o *ListAppsParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *ListAppsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
