// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewCreateAppParams creates a new CreateAppParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateAppParams() *CreateAppParams {
	return &CreateAppParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateAppParamsWithTimeout creates a new CreateAppParams object
// with the ability to set a timeout on a request.
func NewCreateAppParamsWithTimeout(timeout time.Duration) *CreateAppParams {
	return &CreateAppParams{
		timeout: timeout,
	}
}

// NewCreateAppParamsWithContext creates a new CreateAppParams object
// with the ability to set a context for a request.
func NewCreateAppParamsWithContext(ctx context.Context) *CreateAppParams {
	return &CreateAppParams{
		Context: ctx,
	}
}

// NewCreateAppParamsWithHTTPClient creates a new CreateAppParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateAppParamsWithHTTPClient(client *http.Client) *CreateAppParams {
	return &CreateAppParams{
		HTTPClient: client,
	}
}

/*
CreateAppParams contains all the parameters to send to the API endpoint

	for the create app operation.

	Typically these are written to a http.Request.
*/
type CreateAppParams struct {

	// Body.
	Body *models.SecretServiceCreateAppBody

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create app params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateAppParams) WithDefaults() *CreateAppParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create app params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateAppParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create app params
func (o *CreateAppParams) WithTimeout(timeout time.Duration) *CreateAppParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create app params
func (o *CreateAppParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create app params
func (o *CreateAppParams) WithContext(ctx context.Context) *CreateAppParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create app params
func (o *CreateAppParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create app params
func (o *CreateAppParams) WithHTTPClient(client *http.Client) *CreateAppParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create app params
func (o *CreateAppParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create app params
func (o *CreateAppParams) WithBody(body *models.SecretServiceCreateAppBody) *CreateAppParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create app params
func (o *CreateAppParams) SetBody(body *models.SecretServiceCreateAppBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the create app params
func (o *CreateAppParams) WithOrganizationID(organizationID string) *CreateAppParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the create app params
func (o *CreateAppParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the create app params
func (o *CreateAppParams) WithProjectID(projectID string) *CreateAppParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the create app params
func (o *CreateAppParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateAppParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
