// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// CreateAppReader is a Reader for the CreateApp structure.
type CreateAppReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateAppReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateAppOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateAppDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateAppOK creates a CreateAppOK with default headers values
func NewCreateAppOK() *CreateAppOK {
	return &CreateAppOK{}
}

/*
CreateAppOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateAppOK struct {
	Payload *models.Secrets20231128CreateAppResponse
}

// IsSuccess returns true when this create app o k response has a 2xx status code
func (o *CreateAppOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create app o k response has a 3xx status code
func (o *CreateAppOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create app o k response has a 4xx status code
func (o *CreateAppOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create app o k response has a 5xx status code
func (o *CreateAppOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create app o k response a status code equal to that given
func (o *CreateAppOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create app o k response
func (o *CreateAppOK) Code() int {
	return 200
}

func (o *CreateAppOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps][%d] createAppOK %s", 200, payload)
}

func (o *CreateAppOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps][%d] createAppOK %s", 200, payload)
}

func (o *CreateAppOK) GetPayload() *models.Secrets20231128CreateAppResponse {
	return o.Payload
}

func (o *CreateAppOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128CreateAppResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateAppDefault creates a CreateAppDefault with default headers values
func NewCreateAppDefault(code int) *CreateAppDefault {
	return &CreateAppDefault{
		_statusCode: code,
	}
}

/*
CreateAppDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateAppDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this create app default response has a 2xx status code
func (o *CreateAppDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create app default response has a 3xx status code
func (o *CreateAppDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create app default response has a 4xx status code
func (o *CreateAppDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create app default response has a 5xx status code
func (o *CreateAppDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create app default response a status code equal to that given
func (o *CreateAppDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create app default response
func (o *CreateAppDefault) Code() int {
	return o._statusCode
}

func (o *CreateAppDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps][%d] CreateApp default %s", o._statusCode, payload)
}

func (o *CreateAppDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps][%d] CreateApp default %s", o._statusCode, payload)
}

func (o *CreateAppDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *CreateAppDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
