// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewCreateGcpDynamicSecretParams creates a new CreateGcpDynamicSecretParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateGcpDynamicSecretParams() *CreateGcpDynamicSecretParams {
	return &CreateGcpDynamicSecretParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateGcpDynamicSecretParamsWithTimeout creates a new CreateGcpDynamicSecretParams object
// with the ability to set a timeout on a request.
func NewCreateGcpDynamicSecretParamsWithTimeout(timeout time.Duration) *CreateGcpDynamicSecretParams {
	return &CreateGcpDynamicSecretParams{
		timeout: timeout,
	}
}

// NewCreateGcpDynamicSecretParamsWithContext creates a new CreateGcpDynamicSecretParams object
// with the ability to set a context for a request.
func NewCreateGcpDynamicSecretParamsWithContext(ctx context.Context) *CreateGcpDynamicSecretParams {
	return &CreateGcpDynamicSecretParams{
		Context: ctx,
	}
}

// NewCreateGcpDynamicSecretParamsWithHTTPClient creates a new CreateGcpDynamicSecretParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateGcpDynamicSecretParamsWithHTTPClient(client *http.Client) *CreateGcpDynamicSecretParams {
	return &CreateGcpDynamicSecretParams{
		HTTPClient: client,
	}
}

/*
CreateGcpDynamicSecretParams contains all the parameters to send to the API endpoint

	for the create gcp dynamic secret operation.

	Typically these are written to a http.Request.
*/
type CreateGcpDynamicSecretParams struct {

	// AppName.
	AppName string

	// Body.
	Body *models.SecretServiceCreateGcpDynamicSecretBody

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create gcp dynamic secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateGcpDynamicSecretParams) WithDefaults() *CreateGcpDynamicSecretParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create gcp dynamic secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateGcpDynamicSecretParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) WithTimeout(timeout time.Duration) *CreateGcpDynamicSecretParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) WithContext(ctx context.Context) *CreateGcpDynamicSecretParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) WithHTTPClient(client *http.Client) *CreateGcpDynamicSecretParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) WithAppName(appName string) *CreateGcpDynamicSecretParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithBody adds the body to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) WithBody(body *models.SecretServiceCreateGcpDynamicSecretBody) *CreateGcpDynamicSecretParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) SetBody(body *models.SecretServiceCreateGcpDynamicSecretBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) WithOrganizationID(organizationID string) *CreateGcpDynamicSecretParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) WithProjectID(projectID string) *CreateGcpDynamicSecretParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the create gcp dynamic secret params
func (o *CreateGcpDynamicSecretParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateGcpDynamicSecretParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
