// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// DeleteAwsDynamicSecretReader is a Reader for the DeleteAwsDynamicSecret structure.
type DeleteAwsDynamicSecretReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteAwsDynamicSecretReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteAwsDynamicSecretOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeleteAwsDynamicSecretDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeleteAwsDynamicSecretOK creates a DeleteAwsDynamicSecretOK with default headers values
func NewDeleteAwsDynamicSecretOK() *DeleteAwsDynamicSecretOK {
	return &DeleteAwsDynamicSecretOK{}
}

/*
DeleteAwsDynamicSecretOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeleteAwsDynamicSecretOK struct {
	Payload models.Secrets20231128DeleteAwsDynamicSecretResponse
}

// IsSuccess returns true when this delete aws dynamic secret o k response has a 2xx status code
func (o *DeleteAwsDynamicSecretOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete aws dynamic secret o k response has a 3xx status code
func (o *DeleteAwsDynamicSecretOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete aws dynamic secret o k response has a 4xx status code
func (o *DeleteAwsDynamicSecretOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete aws dynamic secret o k response has a 5xx status code
func (o *DeleteAwsDynamicSecretOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete aws dynamic secret o k response a status code equal to that given
func (o *DeleteAwsDynamicSecretOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete aws dynamic secret o k response
func (o *DeleteAwsDynamicSecretOK) Code() int {
	return 200
}

func (o *DeleteAwsDynamicSecretOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret/{name}][%d] deleteAwsDynamicSecretOK %s", 200, payload)
}

func (o *DeleteAwsDynamicSecretOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret/{name}][%d] deleteAwsDynamicSecretOK %s", 200, payload)
}

func (o *DeleteAwsDynamicSecretOK) GetPayload() models.Secrets20231128DeleteAwsDynamicSecretResponse {
	return o.Payload
}

func (o *DeleteAwsDynamicSecretOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteAwsDynamicSecretDefault creates a DeleteAwsDynamicSecretDefault with default headers values
func NewDeleteAwsDynamicSecretDefault(code int) *DeleteAwsDynamicSecretDefault {
	return &DeleteAwsDynamicSecretDefault{
		_statusCode: code,
	}
}

/*
DeleteAwsDynamicSecretDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeleteAwsDynamicSecretDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this delete aws dynamic secret default response has a 2xx status code
func (o *DeleteAwsDynamicSecretDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this delete aws dynamic secret default response has a 3xx status code
func (o *DeleteAwsDynamicSecretDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this delete aws dynamic secret default response has a 4xx status code
func (o *DeleteAwsDynamicSecretDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this delete aws dynamic secret default response has a 5xx status code
func (o *DeleteAwsDynamicSecretDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this delete aws dynamic secret default response a status code equal to that given
func (o *DeleteAwsDynamicSecretDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the delete aws dynamic secret default response
func (o *DeleteAwsDynamicSecretDefault) Code() int {
	return o._statusCode
}

func (o *DeleteAwsDynamicSecretDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret/{name}][%d] DeleteAwsDynamicSecret default %s", o._statusCode, payload)
}

func (o *DeleteAwsDynamicSecretDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret/{name}][%d] DeleteAwsDynamicSecret default %s", o._statusCode, payload)
}

func (o *DeleteAwsDynamicSecretDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *DeleteAwsDynamicSecretDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
