// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetAppRotatingSecretReader is a Reader for the GetAppRotatingSecret structure.
type GetAppRotatingSecretReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAppRotatingSecretReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAppRotatingSecretOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetAppRotatingSecretDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetAppRotatingSecretOK creates a GetAppRotatingSecretOK with default headers values
func NewGetAppRotatingSecretOK() *GetAppRotatingSecretOK {
	return &GetAppRotatingSecretOK{}
}

/*
GetAppRotatingSecretOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetAppRotatingSecretOK struct {
	Payload *models.Secrets20231128GetAppRotatingSecretResponse
}

// IsSuccess returns true when this get app rotating secret o k response has a 2xx status code
func (o *GetAppRotatingSecretOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get app rotating secret o k response has a 3xx status code
func (o *GetAppRotatingSecretOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get app rotating secret o k response has a 4xx status code
func (o *GetAppRotatingSecretOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get app rotating secret o k response has a 5xx status code
func (o *GetAppRotatingSecretOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get app rotating secret o k response a status code equal to that given
func (o *GetAppRotatingSecretOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get app rotating secret o k response
func (o *GetAppRotatingSecretOK) Code() int {
	return 200
}

func (o *GetAppRotatingSecretOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating/{name}][%d] getAppRotatingSecretOK %s", 200, payload)
}

func (o *GetAppRotatingSecretOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating/{name}][%d] getAppRotatingSecretOK %s", 200, payload)
}

func (o *GetAppRotatingSecretOK) GetPayload() *models.Secrets20231128GetAppRotatingSecretResponse {
	return o.Payload
}

func (o *GetAppRotatingSecretOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetAppRotatingSecretResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAppRotatingSecretDefault creates a GetAppRotatingSecretDefault with default headers values
func NewGetAppRotatingSecretDefault(code int) *GetAppRotatingSecretDefault {
	return &GetAppRotatingSecretDefault{
		_statusCode: code,
	}
}

/*
GetAppRotatingSecretDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetAppRotatingSecretDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get app rotating secret default response has a 2xx status code
func (o *GetAppRotatingSecretDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get app rotating secret default response has a 3xx status code
func (o *GetAppRotatingSecretDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get app rotating secret default response has a 4xx status code
func (o *GetAppRotatingSecretDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get app rotating secret default response has a 5xx status code
func (o *GetAppRotatingSecretDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get app rotating secret default response a status code equal to that given
func (o *GetAppRotatingSecretDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get app rotating secret default response
func (o *GetAppRotatingSecretDefault) Code() int {
	return o._statusCode
}

func (o *GetAppRotatingSecretDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating/{name}][%d] GetAppRotatingSecret default %s", o._statusCode, payload)
}

func (o *GetAppRotatingSecretDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating/{name}][%d] GetAppRotatingSecret default %s", o._statusCode, payload)
}

func (o *GetAppRotatingSecretDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetAppRotatingSecretDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
