// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetProjectLockStatusReader is a Reader for the GetProjectLockStatus structure.
type GetProjectLockStatusReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetProjectLockStatusReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetProjectLockStatusOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetProjectLockStatusDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetProjectLockStatusOK creates a GetProjectLockStatusOK with default headers values
func NewGetProjectLockStatusOK() *GetProjectLockStatusOK {
	return &GetProjectLockStatusOK{}
}

/*
GetProjectLockStatusOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetProjectLockStatusOK struct {
	Payload *models.Secrets20231128GetProjectLockStatusResponse
}

// IsSuccess returns true when this get project lock status o k response has a 2xx status code
func (o *GetProjectLockStatusOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get project lock status o k response has a 3xx status code
func (o *GetProjectLockStatusOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get project lock status o k response has a 4xx status code
func (o *GetProjectLockStatusOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get project lock status o k response has a 5xx status code
func (o *GetProjectLockStatusOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get project lock status o k response a status code equal to that given
func (o *GetProjectLockStatusOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get project lock status o k response
func (o *GetProjectLockStatusOK) Code() int {
	return 200
}

func (o *GetProjectLockStatusOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/lock-status][%d] getProjectLockStatusOK %s", 200, payload)
}

func (o *GetProjectLockStatusOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/lock-status][%d] getProjectLockStatusOK %s", 200, payload)
}

func (o *GetProjectLockStatusOK) GetPayload() *models.Secrets20231128GetProjectLockStatusResponse {
	return o.Payload
}

func (o *GetProjectLockStatusOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetProjectLockStatusResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetProjectLockStatusDefault creates a GetProjectLockStatusDefault with default headers values
func NewGetProjectLockStatusDefault(code int) *GetProjectLockStatusDefault {
	return &GetProjectLockStatusDefault{
		_statusCode: code,
	}
}

/*
GetProjectLockStatusDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetProjectLockStatusDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get project lock status default response has a 2xx status code
func (o *GetProjectLockStatusDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get project lock status default response has a 3xx status code
func (o *GetProjectLockStatusDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get project lock status default response has a 4xx status code
func (o *GetProjectLockStatusDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get project lock status default response has a 5xx status code
func (o *GetProjectLockStatusDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get project lock status default response a status code equal to that given
func (o *GetProjectLockStatusDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get project lock status default response
func (o *GetProjectLockStatusDefault) Code() int {
	return o._statusCode
}

func (o *GetProjectLockStatusDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/lock-status][%d] GetProjectLockStatus default %s", o._statusCode, payload)
}

func (o *GetProjectLockStatusDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/lock-status][%d] GetProjectLockStatus default %s", o._statusCode, payload)
}

func (o *GetProjectLockStatusDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetProjectLockStatusDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
