// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListAppSecretsParams creates a new ListAppSecretsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListAppSecretsParams() *ListAppSecretsParams {
	return &ListAppSecretsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListAppSecretsParamsWithTimeout creates a new ListAppSecretsParams object
// with the ability to set a timeout on a request.
func NewListAppSecretsParamsWithTimeout(timeout time.Duration) *ListAppSecretsParams {
	return &ListAppSecretsParams{
		timeout: timeout,
	}
}

// NewListAppSecretsParamsWithContext creates a new ListAppSecretsParams object
// with the ability to set a context for a request.
func NewListAppSecretsParamsWithContext(ctx context.Context) *ListAppSecretsParams {
	return &ListAppSecretsParams{
		Context: ctx,
	}
}

// NewListAppSecretsParamsWithHTTPClient creates a new ListAppSecretsParams object
// with the ability to set a custom HTTPClient for a request.
func NewListAppSecretsParamsWithHTTPClient(client *http.Client) *ListAppSecretsParams {
	return &ListAppSecretsParams{
		HTTPClient: client,
	}
}

/*
ListAppSecretsParams contains all the parameters to send to the API endpoint

	for the list app secrets operation.

	Typically these are written to a http.Request.
*/
type ListAppSecretsParams struct {

	// AppName.
	AppName string

	// NameContains.
	NameContains *string

	// OrganizationID.
	OrganizationID string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	// ProjectID.
	ProjectID string

	// Types.
	Types []string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list app secrets params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListAppSecretsParams) WithDefaults() *ListAppSecretsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list app secrets params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListAppSecretsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list app secrets params
func (o *ListAppSecretsParams) WithTimeout(timeout time.Duration) *ListAppSecretsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list app secrets params
func (o *ListAppSecretsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list app secrets params
func (o *ListAppSecretsParams) WithContext(ctx context.Context) *ListAppSecretsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list app secrets params
func (o *ListAppSecretsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list app secrets params
func (o *ListAppSecretsParams) WithHTTPClient(client *http.Client) *ListAppSecretsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list app secrets params
func (o *ListAppSecretsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the list app secrets params
func (o *ListAppSecretsParams) WithAppName(appName string) *ListAppSecretsParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the list app secrets params
func (o *ListAppSecretsParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithNameContains adds the nameContains to the list app secrets params
func (o *ListAppSecretsParams) WithNameContains(nameContains *string) *ListAppSecretsParams {
	o.SetNameContains(nameContains)
	return o
}

// SetNameContains adds the nameContains to the list app secrets params
func (o *ListAppSecretsParams) SetNameContains(nameContains *string) {
	o.NameContains = nameContains
}

// WithOrganizationID adds the organizationID to the list app secrets params
func (o *ListAppSecretsParams) WithOrganizationID(organizationID string) *ListAppSecretsParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the list app secrets params
func (o *ListAppSecretsParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the list app secrets params
func (o *ListAppSecretsParams) WithPaginationNextPageToken(paginationNextPageToken *string) *ListAppSecretsParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the list app secrets params
func (o *ListAppSecretsParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the list app secrets params
func (o *ListAppSecretsParams) WithPaginationPageSize(paginationPageSize *int64) *ListAppSecretsParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the list app secrets params
func (o *ListAppSecretsParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the list app secrets params
func (o *ListAppSecretsParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *ListAppSecretsParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the list app secrets params
func (o *ListAppSecretsParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithProjectID adds the projectID to the list app secrets params
func (o *ListAppSecretsParams) WithProjectID(projectID string) *ListAppSecretsParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the list app secrets params
func (o *ListAppSecretsParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WithTypes adds the types to the list app secrets params
func (o *ListAppSecretsParams) WithTypes(types []string) *ListAppSecretsParams {
	o.SetTypes(types)
	return o
}

// SetTypes adds the types to the list app secrets params
func (o *ListAppSecretsParams) SetTypes(types []string) {
	o.Types = types
}

// WriteToRequest writes these params to a swagger request
func (o *ListAppSecretsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}

	if o.NameContains != nil {

		// query param name_contains
		var qrNameContains string

		if o.NameContains != nil {
			qrNameContains = *o.NameContains
		}
		qNameContains := qrNameContains
		if qNameContains != "" {

			if err := r.SetQueryParam("name_contains", qNameContains); err != nil {
				return err
			}
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if o.Types != nil {

		// binding items for types
		joinedTypes := o.bindParamTypes(reg)

		// query array param types
		if err := r.SetQueryParam("types", joinedTypes...); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamListAppSecrets binds the parameter types
func (o *ListAppSecretsParams) bindParamTypes(formats strfmt.Registry) []string {
	typesIR := o.Types

	var typesIC []string
	for _, typesIIR := range typesIR { // explode []string

		typesIIV := typesIIR // string as string
		typesIC = append(typesIC, typesIIV)
	}

	// items.CollectionFormat: "multi"
	typesIS := swag.JoinByFormat(typesIC, "multi")

	return typesIS
}
