// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// ListIntegrationsReader is a Reader for the ListIntegrations structure.
type ListIntegrationsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListIntegrationsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListIntegrationsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListIntegrationsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListIntegrationsOK creates a ListIntegrationsOK with default headers values
func NewListIntegrationsOK() *ListIntegrationsOK {
	return &ListIntegrationsOK{}
}

/*
ListIntegrationsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListIntegrationsOK struct {
	Payload *models.Secrets20231128ListIntegrationsResponse
}

// IsSuccess returns true when this list integrations o k response has a 2xx status code
func (o *ListIntegrationsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list integrations o k response has a 3xx status code
func (o *ListIntegrationsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list integrations o k response has a 4xx status code
func (o *ListIntegrationsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list integrations o k response has a 5xx status code
func (o *ListIntegrationsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list integrations o k response a status code equal to that given
func (o *ListIntegrationsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list integrations o k response
func (o *ListIntegrationsOK) Code() int {
	return 200
}

func (o *ListIntegrationsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations][%d] listIntegrationsOK %s", 200, payload)
}

func (o *ListIntegrationsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations][%d] listIntegrationsOK %s", 200, payload)
}

func (o *ListIntegrationsOK) GetPayload() *models.Secrets20231128ListIntegrationsResponse {
	return o.Payload
}

func (o *ListIntegrationsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128ListIntegrationsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListIntegrationsDefault creates a ListIntegrationsDefault with default headers values
func NewListIntegrationsDefault(code int) *ListIntegrationsDefault {
	return &ListIntegrationsDefault{
		_statusCode: code,
	}
}

/*
ListIntegrationsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListIntegrationsDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this list integrations default response has a 2xx status code
func (o *ListIntegrationsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list integrations default response has a 3xx status code
func (o *ListIntegrationsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list integrations default response has a 4xx status code
func (o *ListIntegrationsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list integrations default response has a 5xx status code
func (o *ListIntegrationsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list integrations default response a status code equal to that given
func (o *ListIntegrationsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list integrations default response
func (o *ListIntegrationsDefault) Code() int {
	return o._statusCode
}

func (o *ListIntegrationsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations][%d] ListIntegrations default %s", o._statusCode, payload)
}

func (o *ListIntegrationsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations][%d] ListIntegrations default %s", o._statusCode, payload)
}

func (o *ListIntegrationsDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *ListIntegrationsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
