// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// ListSyncsReader is a Reader for the ListSyncs structure.
type ListSyncsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListSyncsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListSyncsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListSyncsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListSyncsOK creates a ListSyncsOK with default headers values
func NewListSyncsOK() *ListSyncsOK {
	return &ListSyncsOK{}
}

/*
ListSyncsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListSyncsOK struct {
	Payload *models.Secrets20231128ListSyncsResponse
}

// IsSuccess returns true when this list syncs o k response has a 2xx status code
func (o *ListSyncsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list syncs o k response has a 3xx status code
func (o *ListSyncsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list syncs o k response has a 4xx status code
func (o *ListSyncsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list syncs o k response has a 5xx status code
func (o *ListSyncsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list syncs o k response a status code equal to that given
func (o *ListSyncsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list syncs o k response
func (o *ListSyncsOK) Code() int {
	return 200
}

func (o *ListSyncsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/syncs][%d] listSyncsOK %s", 200, payload)
}

func (o *ListSyncsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/syncs][%d] listSyncsOK %s", 200, payload)
}

func (o *ListSyncsOK) GetPayload() *models.Secrets20231128ListSyncsResponse {
	return o.Payload
}

func (o *ListSyncsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128ListSyncsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListSyncsDefault creates a ListSyncsDefault with default headers values
func NewListSyncsDefault(code int) *ListSyncsDefault {
	return &ListSyncsDefault{
		_statusCode: code,
	}
}

/*
ListSyncsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListSyncsDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this list syncs default response has a 2xx status code
func (o *ListSyncsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list syncs default response has a 3xx status code
func (o *ListSyncsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list syncs default response has a 4xx status code
func (o *ListSyncsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list syncs default response has a 5xx status code
func (o *ListSyncsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list syncs default response a status code equal to that given
func (o *ListSyncsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list syncs default response
func (o *ListSyncsDefault) Code() int {
	return o._statusCode
}

func (o *ListSyncsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/syncs][%d] ListSyncs default %s", o._statusCode, payload)
}

func (o *ListSyncsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/syncs][%d] ListSyncs default %s", o._statusCode, payload)
}

func (o *ListSyncsDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *ListSyncsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
