// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewUpdateConfluentIntegrationParams creates a new UpdateConfluentIntegrationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateConfluentIntegrationParams() *UpdateConfluentIntegrationParams {
	return &UpdateConfluentIntegrationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateConfluentIntegrationParamsWithTimeout creates a new UpdateConfluentIntegrationParams object
// with the ability to set a timeout on a request.
func NewUpdateConfluentIntegrationParamsWithTimeout(timeout time.Duration) *UpdateConfluentIntegrationParams {
	return &UpdateConfluentIntegrationParams{
		timeout: timeout,
	}
}

// NewUpdateConfluentIntegrationParamsWithContext creates a new UpdateConfluentIntegrationParams object
// with the ability to set a context for a request.
func NewUpdateConfluentIntegrationParamsWithContext(ctx context.Context) *UpdateConfluentIntegrationParams {
	return &UpdateConfluentIntegrationParams{
		Context: ctx,
	}
}

// NewUpdateConfluentIntegrationParamsWithHTTPClient creates a new UpdateConfluentIntegrationParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateConfluentIntegrationParamsWithHTTPClient(client *http.Client) *UpdateConfluentIntegrationParams {
	return &UpdateConfluentIntegrationParams{
		HTTPClient: client,
	}
}

/*
UpdateConfluentIntegrationParams contains all the parameters to send to the API endpoint

	for the update confluent integration operation.

	Typically these are written to a http.Request.
*/
type UpdateConfluentIntegrationParams struct {

	// Body.
	Body *models.SecretServiceUpdateConfluentIntegrationBody

	// Name.
	Name string

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update confluent integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateConfluentIntegrationParams) WithDefaults() *UpdateConfluentIntegrationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update confluent integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateConfluentIntegrationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) WithTimeout(timeout time.Duration) *UpdateConfluentIntegrationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) WithContext(ctx context.Context) *UpdateConfluentIntegrationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) WithHTTPClient(client *http.Client) *UpdateConfluentIntegrationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) WithBody(body *models.SecretServiceUpdateConfluentIntegrationBody) *UpdateConfluentIntegrationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) SetBody(body *models.SecretServiceUpdateConfluentIntegrationBody) {
	o.Body = body
}

// WithName adds the name to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) WithName(name string) *UpdateConfluentIntegrationParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) SetName(name string) {
	o.Name = name
}

// WithOrganizationID adds the organizationID to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) WithOrganizationID(organizationID string) *UpdateConfluentIntegrationParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) WithProjectID(projectID string) *UpdateConfluentIntegrationParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the update confluent integration params
func (o *UpdateConfluentIntegrationParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateConfluentIntegrationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
