// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetAvailableTemplatesParams creates a new GetAvailableTemplatesParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAvailableTemplatesParams() *GetAvailableTemplatesParams {
	return &GetAvailableTemplatesParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAvailableTemplatesParamsWithTimeout creates a new GetAvailableTemplatesParams object
// with the ability to set a timeout on a request.
func NewGetAvailableTemplatesParamsWithTimeout(timeout time.Duration) *GetAvailableTemplatesParams {
	return &GetAvailableTemplatesParams{
		timeout: timeout,
	}
}

// NewGetAvailableTemplatesParamsWithContext creates a new GetAvailableTemplatesParams object
// with the ability to set a context for a request.
func NewGetAvailableTemplatesParamsWithContext(ctx context.Context) *GetAvailableTemplatesParams {
	return &GetAvailableTemplatesParams{
		Context: ctx,
	}
}

// NewGetAvailableTemplatesParamsWithHTTPClient creates a new GetAvailableTemplatesParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetAvailableTemplatesParamsWithHTTPClient(client *http.Client) *GetAvailableTemplatesParams {
	return &GetAvailableTemplatesParams{
		HTTPClient: client,
	}
}

/*
GetAvailableTemplatesParams contains all the parameters to send to the API endpoint

	for the get available templates operation.

	Typically these are written to a http.Request.
*/
type GetAvailableTemplatesParams struct {

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get available templates params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAvailableTemplatesParams) WithDefaults() *GetAvailableTemplatesParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get available templates params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAvailableTemplatesParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get available templates params
func (o *GetAvailableTemplatesParams) WithTimeout(timeout time.Duration) *GetAvailableTemplatesParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get available templates params
func (o *GetAvailableTemplatesParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get available templates params
func (o *GetAvailableTemplatesParams) WithContext(ctx context.Context) *GetAvailableTemplatesParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get available templates params
func (o *GetAvailableTemplatesParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get available templates params
func (o *GetAvailableTemplatesParams) WithHTTPClient(client *http.Client) *GetAvailableTemplatesParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get available templates params
func (o *GetAvailableTemplatesParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLocationOrganizationID adds the locationOrganizationID to the get available templates params
func (o *GetAvailableTemplatesParams) WithLocationOrganizationID(locationOrganizationID string) *GetAvailableTemplatesParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the get available templates params
func (o *GetAvailableTemplatesParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the get available templates params
func (o *GetAvailableTemplatesParams) WithLocationProjectID(locationProjectID string) *GetAvailableTemplatesParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the get available templates params
func (o *GetAvailableTemplatesParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the get available templates params
func (o *GetAvailableTemplatesParams) WithLocationRegionProvider(locationRegionProvider *string) *GetAvailableTemplatesParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the get available templates params
func (o *GetAvailableTemplatesParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the get available templates params
func (o *GetAvailableTemplatesParams) WithLocationRegionRegion(locationRegionRegion *string) *GetAvailableTemplatesParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the get available templates params
func (o *GetAvailableTemplatesParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *GetAvailableTemplatesParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
