// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceUIGetActionConfigBundle2Params creates a new WaypointServiceUIGetActionConfigBundle2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceUIGetActionConfigBundle2Params() *WaypointServiceUIGetActionConfigBundle2Params {
	return &WaypointServiceUIGetActionConfigBundle2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceUIGetActionConfigBundle2ParamsWithTimeout creates a new WaypointServiceUIGetActionConfigBundle2Params object
// with the ability to set a timeout on a request.
func NewWaypointServiceUIGetActionConfigBundle2ParamsWithTimeout(timeout time.Duration) *WaypointServiceUIGetActionConfigBundle2Params {
	return &WaypointServiceUIGetActionConfigBundle2Params{
		timeout: timeout,
	}
}

// NewWaypointServiceUIGetActionConfigBundle2ParamsWithContext creates a new WaypointServiceUIGetActionConfigBundle2Params object
// with the ability to set a context for a request.
func NewWaypointServiceUIGetActionConfigBundle2ParamsWithContext(ctx context.Context) *WaypointServiceUIGetActionConfigBundle2Params {
	return &WaypointServiceUIGetActionConfigBundle2Params{
		Context: ctx,
	}
}

// NewWaypointServiceUIGetActionConfigBundle2ParamsWithHTTPClient creates a new WaypointServiceUIGetActionConfigBundle2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceUIGetActionConfigBundle2ParamsWithHTTPClient(client *http.Client) *WaypointServiceUIGetActionConfigBundle2Params {
	return &WaypointServiceUIGetActionConfigBundle2Params{
		HTTPClient: client,
	}
}

/*
WaypointServiceUIGetActionConfigBundle2Params contains all the parameters to send to the API endpoint

	for the waypoint service UI get action config bundle2 operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceUIGetActionConfigBundle2Params struct {

	/* ActionID.

	   The id of the action config being requested
	*/
	ActionID *string

	/* ActionName.

	   The name of the action being requested (will only be used if id not provided)
	*/
	ActionName string

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID *string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID *string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service UI get action config bundle2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceUIGetActionConfigBundle2Params) WithDefaults() *WaypointServiceUIGetActionConfigBundle2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service UI get action config bundle2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceUIGetActionConfigBundle2Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) WithTimeout(timeout time.Duration) *WaypointServiceUIGetActionConfigBundle2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) WithContext(ctx context.Context) *WaypointServiceUIGetActionConfigBundle2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) WithHTTPClient(client *http.Client) *WaypointServiceUIGetActionConfigBundle2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActionID adds the actionID to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) WithActionID(actionID *string) *WaypointServiceUIGetActionConfigBundle2Params {
	o.SetActionID(actionID)
	return o
}

// SetActionID adds the actionId to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) SetActionID(actionID *string) {
	o.ActionID = actionID
}

// WithActionName adds the actionName to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) WithActionName(actionName string) *WaypointServiceUIGetActionConfigBundle2Params {
	o.SetActionName(actionName)
	return o
}

// SetActionName adds the actionName to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) SetActionName(actionName string) {
	o.ActionName = actionName
}

// WithNamespaceID adds the namespaceID to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) WithNamespaceID(namespaceID string) *WaypointServiceUIGetActionConfigBundle2Params {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) *WaypointServiceUIGetActionConfigBundle2Params {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) WithNamespaceLocationProjectID(namespaceLocationProjectID *string) *WaypointServiceUIGetActionConfigBundle2Params {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) SetNamespaceLocationProjectID(namespaceLocationProjectID *string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceUIGetActionConfigBundle2Params {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceUIGetActionConfigBundle2Params {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service UI get action config bundle2 params
func (o *WaypointServiceUIGetActionConfigBundle2Params) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceUIGetActionConfigBundle2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ActionID != nil {

		// query param action_id
		var qrActionID string

		if o.ActionID != nil {
			qrActionID = *o.ActionID
		}
		qActionID := qrActionID
		if qActionID != "" {

			if err := r.SetQueryParam("action_id", qActionID); err != nil {
				return err
			}
		}
	}

	// path param action_name
	if err := r.SetPathParam("action_name", o.ActionName); err != nil {
		return err
	}

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationOrganizationID != nil {

		// query param namespace.location.organization_id
		var qrNamespaceLocationOrganizationID string

		if o.NamespaceLocationOrganizationID != nil {
			qrNamespaceLocationOrganizationID = *o.NamespaceLocationOrganizationID
		}
		qNamespaceLocationOrganizationID := qrNamespaceLocationOrganizationID
		if qNamespaceLocationOrganizationID != "" {

			if err := r.SetQueryParam("namespace.location.organization_id", qNamespaceLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationProjectID != nil {

		// query param namespace.location.project_id
		var qrNamespaceLocationProjectID string

		if o.NamespaceLocationProjectID != nil {
			qrNamespaceLocationProjectID = *o.NamespaceLocationProjectID
		}
		qNamespaceLocationProjectID := qrNamespaceLocationProjectID
		if qNamespaceLocationProjectID != "" {

			if err := r.SetQueryParam("namespace.location.project_id", qNamespaceLocationProjectID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
