// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudWaypointApplicationTemplate hashicorp cloud waypoint application template
//
// swagger:model hashicorp.cloud.waypoint.ApplicationTemplate
type HashicorpCloudWaypointApplicationTemplate struct {

	// The actions configurations assignments for the application template. Can
	// have 0-Many action configurations.
	ActionCfgRefs []*HashicorpCloudWaypointActionCfgRef `json:"action_cfg_refs"`

	// A long-form description of what the ApplicationTemplate is to be used for. This description
	// is shared between platform engineers and application developers.
	Description string `json:"description,omitempty"`

	// Unique ID of the ApplicationTemplate
	ID string `json:"id,omitempty"`

	// A list of descriptive strings that can be applied to the ApplicationTemplate.
	Labels []string `json:"labels"`

	// module_id is the ID of the template's Terraform module. Clients are
	// expected to set this field when creating a new application template.
	ModuleID string `json:"module_id,omitempty"`

	// module_source is where to find the source code for the desired child module.
	ModuleSource string `json:"module_source,omitempty"`

	// Unique name of the ApplicationTemplate
	Name string `json:"name,omitempty"`

	// A markdown text template which is rendered when an Application is created from a
	// ApplicationTemplate to be shown to application developers.
	// Accepted tokens:
	// "{{ .ApplicationName }}", representing the application developer chosen application name
	// "{{ .TfcOrgName }}", representing the Terraform Cloud organization name in which
	//  the no-code module was reified
	// Format: byte
	ReadmeMarkdownTemplate strfmt.Base64 `json:"readme_markdown_template,omitempty"`

	// A markdown text template which is rendered when an Application is created from a
	// ApplicationTemplate to be shown to application developers.
	// Accepted tokens:
	// "{{ .ApplicationName }}", representing the application developer chosen application name
	// "{{ .TfcOrgName }}", representing the Terraform Cloud organization name in which
	//  the no-code module was reified.
	// This field is favored over readme_markdown_template and support for both is transitional.
	ReadmeTemplate string `json:"readme_template,omitempty"`

	// A short summary for use by platform engineers to distinguish between
	// multiple templates
	Summary string `json:"summary,omitempty"`

	// kv tags
	// see infrastructure.proto
	Tags []*HashicorpCloudWaypointTag `json:"tags"`

	// The information on meta data on the Terraform Cloud workspace that was
	// created when this project was created from a template.
	TerraformCloudWorkspaceDetails *HashicorpCloudWaypointTerraformCloudWorkspaceDetails `json:"terraform_cloud_workspace_details,omitempty"`

	// tf_agent_pool_id is the ID of the agent pool to use for the Terraform
	// workspace if 'agent' is used for 'tf_execution_mode'.
	TfAgentPoolID string `json:"tf_agent_pool_id,omitempty"`

	// tf_execution_mode is the mode in which the Terraform backed workspace should
	// operate in. Defaults to 'remote'.
	TfExecutionMode string `json:"tf_execution_mode,omitempty"`

	// variable_options is the collection of input variables which may be set for an application.
	VariableOptions []*HashicorpCloudWaypointTFModuleVariable `json:"variable_options"`

	// variable_options_out_of_sync is a boolean value that indicates whether the variable_options
	// are out of sync with the Terraform no-code module, published in Terraform Cloud.
	// This is used to determine whether the variable_options should be updated.
	// API client should not set this value.
	// Read Only: true
	VariableOptionsOutOfSync *bool `json:"variable_options_out_of_sync,omitempty"`
}

// Validate validates this hashicorp cloud waypoint application template
func (m *HashicorpCloudWaypointApplicationTemplate) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateActionCfgRefs(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTags(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTerraformCloudWorkspaceDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVariableOptions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointApplicationTemplate) validateActionCfgRefs(formats strfmt.Registry) error {
	if swag.IsZero(m.ActionCfgRefs) { // not required
		return nil
	}

	for i := 0; i < len(m.ActionCfgRefs); i++ {
		if swag.IsZero(m.ActionCfgRefs[i]) { // not required
			continue
		}

		if m.ActionCfgRefs[i] != nil {
			if err := m.ActionCfgRefs[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("action_cfg_refs" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("action_cfg_refs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointApplicationTemplate) validateTags(formats strfmt.Registry) error {
	if swag.IsZero(m.Tags) { // not required
		return nil
	}

	for i := 0; i < len(m.Tags); i++ {
		if swag.IsZero(m.Tags[i]) { // not required
			continue
		}

		if m.Tags[i] != nil {
			if err := m.Tags[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tags" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("tags" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointApplicationTemplate) validateTerraformCloudWorkspaceDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.TerraformCloudWorkspaceDetails) { // not required
		return nil
	}

	if m.TerraformCloudWorkspaceDetails != nil {
		if err := m.TerraformCloudWorkspaceDetails.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("terraform_cloud_workspace_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("terraform_cloud_workspace_details")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointApplicationTemplate) validateVariableOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.VariableOptions) { // not required
		return nil
	}

	for i := 0; i < len(m.VariableOptions); i++ {
		if swag.IsZero(m.VariableOptions[i]) { // not required
			continue
		}

		if m.VariableOptions[i] != nil {
			if err := m.VariableOptions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variable_options" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variable_options" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint application template based on the context it is used
func (m *HashicorpCloudWaypointApplicationTemplate) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateActionCfgRefs(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTags(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTerraformCloudWorkspaceDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVariableOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVariableOptionsOutOfSync(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointApplicationTemplate) contextValidateActionCfgRefs(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ActionCfgRefs); i++ {

		if m.ActionCfgRefs[i] != nil {

			if swag.IsZero(m.ActionCfgRefs[i]) { // not required
				return nil
			}

			if err := m.ActionCfgRefs[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("action_cfg_refs" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("action_cfg_refs" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointApplicationTemplate) contextValidateTags(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Tags); i++ {

		if m.Tags[i] != nil {

			if swag.IsZero(m.Tags[i]) { // not required
				return nil
			}

			if err := m.Tags[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tags" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("tags" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointApplicationTemplate) contextValidateTerraformCloudWorkspaceDetails(ctx context.Context, formats strfmt.Registry) error {

	if m.TerraformCloudWorkspaceDetails != nil {

		if swag.IsZero(m.TerraformCloudWorkspaceDetails) { // not required
			return nil
		}

		if err := m.TerraformCloudWorkspaceDetails.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("terraform_cloud_workspace_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("terraform_cloud_workspace_details")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointApplicationTemplate) contextValidateVariableOptions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VariableOptions); i++ {

		if m.VariableOptions[i] != nil {

			if swag.IsZero(m.VariableOptions[i]) { // not required
				return nil
			}

			if err := m.VariableOptions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variable_options" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variable_options" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointApplicationTemplate) contextValidateVariableOptionsOutOfSync(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "variable_options_out_of_sync", "body", m.VariableOptionsOutOfSync); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointApplicationTemplate) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointApplicationTemplate) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointApplicationTemplate
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
