// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointServiceListAddOnsParams creates a new WaypointServiceListAddOnsParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceListAddOnsParams() *WaypointServiceListAddOnsParams {
	return &WaypointServiceListAddOnsParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceListAddOnsParamsWithTimeout creates a new WaypointServiceListAddOnsParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceListAddOnsParamsWithTimeout(timeout time.Duration) *WaypointServiceListAddOnsParams {
	return &WaypointServiceListAddOnsParams{
		timeout: timeout,
	}
}

// NewWaypointServiceListAddOnsParamsWithContext creates a new WaypointServiceListAddOnsParams object
// with the ability to set a context for a request.
func NewWaypointServiceListAddOnsParamsWithContext(ctx context.Context) *WaypointServiceListAddOnsParams {
	return &WaypointServiceListAddOnsParams{
		Context: ctx,
	}
}

// NewWaypointServiceListAddOnsParamsWithHTTPClient creates a new WaypointServiceListAddOnsParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceListAddOnsParamsWithHTTPClient(client *http.Client) *WaypointServiceListAddOnsParams {
	return &WaypointServiceListAddOnsParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceListAddOnsParams contains all the parameters to send to the API endpoint

	for the waypoint service list add ons operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceListAddOnsParams struct {

	// ApplicationID.
	ApplicationID *string

	// ApplicationName.
	ApplicationName *string

	// NamespaceID.
	NamespaceID *string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* WithTotalCount.

	   If set to false or not provided, response will not include a total_count value
	*/
	WithTotalCount *bool

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service list add ons params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceListAddOnsParams) WithDefaults() *WaypointServiceListAddOnsParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service list add ons params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceListAddOnsParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithTimeout(timeout time.Duration) *WaypointServiceListAddOnsParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithContext(ctx context.Context) *WaypointServiceListAddOnsParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithHTTPClient(client *http.Client) *WaypointServiceListAddOnsParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationID adds the applicationID to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithApplicationID(applicationID *string) *WaypointServiceListAddOnsParams {
	o.SetApplicationID(applicationID)
	return o
}

// SetApplicationID adds the applicationId to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetApplicationID(applicationID *string) {
	o.ApplicationID = applicationID
}

// WithApplicationName adds the applicationName to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithApplicationName(applicationName *string) *WaypointServiceListAddOnsParams {
	o.SetApplicationName(applicationName)
	return o
}

// SetApplicationName adds the applicationName to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetApplicationName(applicationName *string) {
	o.ApplicationName = applicationName
}

// WithNamespaceID adds the namespaceID to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithNamespaceID(namespaceID *string) *WaypointServiceListAddOnsParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetNamespaceID(namespaceID *string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) *WaypointServiceListAddOnsParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithNamespaceLocationProjectID(namespaceLocationProjectID string) *WaypointServiceListAddOnsParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetNamespaceLocationProjectID(namespaceLocationProjectID string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceListAddOnsParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceListAddOnsParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithPaginationNextPageToken(paginationNextPageToken *string) *WaypointServiceListAddOnsParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithPaginationPageSize(paginationPageSize *int64) *WaypointServiceListAddOnsParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *WaypointServiceListAddOnsParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithWithTotalCount adds the withTotalCount to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) WithWithTotalCount(withTotalCount *bool) *WaypointServiceListAddOnsParams {
	o.SetWithTotalCount(withTotalCount)
	return o
}

// SetWithTotalCount adds the withTotalCount to the waypoint service list add ons params
func (o *WaypointServiceListAddOnsParams) SetWithTotalCount(withTotalCount *bool) {
	o.WithTotalCount = withTotalCount
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceListAddOnsParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ApplicationID != nil {

		// query param application.id
		var qrApplicationID string

		if o.ApplicationID != nil {
			qrApplicationID = *o.ApplicationID
		}
		qApplicationID := qrApplicationID
		if qApplicationID != "" {

			if err := r.SetQueryParam("application.id", qApplicationID); err != nil {
				return err
			}
		}
	}

	if o.ApplicationName != nil {

		// query param application.name
		var qrApplicationName string

		if o.ApplicationName != nil {
			qrApplicationName = *o.ApplicationName
		}
		qApplicationName := qrApplicationName
		if qApplicationName != "" {

			if err := r.SetQueryParam("application.name", qApplicationName); err != nil {
				return err
			}
		}
	}

	if o.NamespaceID != nil {

		// query param namespace.id
		var qrNamespaceID string

		if o.NamespaceID != nil {
			qrNamespaceID = *o.NamespaceID
		}
		qNamespaceID := qrNamespaceID
		if qNamespaceID != "" {

			if err := r.SetQueryParam("namespace.id", qNamespaceID); err != nil {
				return err
			}
		}
	}

	// path param namespace.location.organization_id
	if err := r.SetPathParam("namespace.location.organization_id", o.NamespaceLocationOrganizationID); err != nil {
		return err
	}

	// path param namespace.location.project_id
	if err := r.SetPathParam("namespace.location.project_id", o.NamespaceLocationProjectID); err != nil {
		return err
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	if o.WithTotalCount != nil {

		// query param with_total_count
		var qrWithTotalCount bool

		if o.WithTotalCount != nil {
			qrWithTotalCount = *o.WithTotalCount
		}
		qWithTotalCount := swag.FormatBool(qrWithTotalCount)
		if qWithTotalCount != "" {

			if err := r.SetQueryParam("with_total_count", qWithTotalCount); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
