// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceUpdateActionConfigReader is a Reader for the WaypointServiceUpdateActionConfig structure.
type WaypointServiceUpdateActionConfigReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceUpdateActionConfigReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceUpdateActionConfigOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceUpdateActionConfigDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceUpdateActionConfigOK creates a WaypointServiceUpdateActionConfigOK with default headers values
func NewWaypointServiceUpdateActionConfigOK() *WaypointServiceUpdateActionConfigOK {
	return &WaypointServiceUpdateActionConfigOK{}
}

/*
WaypointServiceUpdateActionConfigOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceUpdateActionConfigOK struct {
	Payload *models.HashicorpCloudWaypointUpdateActionConfigResponse
}

// IsSuccess returns true when this waypoint service update action config o k response has a 2xx status code
func (o *WaypointServiceUpdateActionConfigOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service update action config o k response has a 3xx status code
func (o *WaypointServiceUpdateActionConfigOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service update action config o k response has a 4xx status code
func (o *WaypointServiceUpdateActionConfigOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service update action config o k response has a 5xx status code
func (o *WaypointServiceUpdateActionConfigOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service update action config o k response a status code equal to that given
func (o *WaypointServiceUpdateActionConfigOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service update action config o k response
func (o *WaypointServiceUpdateActionConfigOK) Code() int {
	return 200
}

func (o *WaypointServiceUpdateActionConfigOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/actionconfig][%d] waypointServiceUpdateActionConfigOK %s", 200, payload)
}

func (o *WaypointServiceUpdateActionConfigOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/actionconfig][%d] waypointServiceUpdateActionConfigOK %s", 200, payload)
}

func (o *WaypointServiceUpdateActionConfigOK) GetPayload() *models.HashicorpCloudWaypointUpdateActionConfigResponse {
	return o.Payload
}

func (o *WaypointServiceUpdateActionConfigOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointUpdateActionConfigResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceUpdateActionConfigDefault creates a WaypointServiceUpdateActionConfigDefault with default headers values
func NewWaypointServiceUpdateActionConfigDefault(code int) *WaypointServiceUpdateActionConfigDefault {
	return &WaypointServiceUpdateActionConfigDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceUpdateActionConfigDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceUpdateActionConfigDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service update action config default response has a 2xx status code
func (o *WaypointServiceUpdateActionConfigDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service update action config default response has a 3xx status code
func (o *WaypointServiceUpdateActionConfigDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service update action config default response has a 4xx status code
func (o *WaypointServiceUpdateActionConfigDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service update action config default response has a 5xx status code
func (o *WaypointServiceUpdateActionConfigDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service update action config default response a status code equal to that given
func (o *WaypointServiceUpdateActionConfigDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service update action config default response
func (o *WaypointServiceUpdateActionConfigDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceUpdateActionConfigDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/actionconfig][%d] WaypointService_UpdateActionConfig default %s", o._statusCode, payload)
}

func (o *WaypointServiceUpdateActionConfigDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/actionconfig][%d] WaypointService_UpdateActionConfig default %s", o._statusCode, payload)
}

func (o *WaypointServiceUpdateActionConfigDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceUpdateActionConfigDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
