// Code generated by go-swagger; DO NOT EDIT.

package webhook_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-webhook/stable/2023-05-31/models"
)

// WebhookServiceCreateWebhookReader is a Reader for the WebhookServiceCreateWebhook structure.
type WebhookServiceCreateWebhookReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WebhookServiceCreateWebhookReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWebhookServiceCreateWebhookOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWebhookServiceCreateWebhookDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWebhookServiceCreateWebhookOK creates a WebhookServiceCreateWebhookOK with default headers values
func NewWebhookServiceCreateWebhookOK() *WebhookServiceCreateWebhookOK {
	return &WebhookServiceCreateWebhookOK{}
}

/*
WebhookServiceCreateWebhookOK describes a response with status code 200, with default header values.

A successful response.
*/
type WebhookServiceCreateWebhookOK struct {
	Payload *models.HashicorpCloudWebhookCreateWebhookResponse
}

// IsSuccess returns true when this webhook service create webhook o k response has a 2xx status code
func (o *WebhookServiceCreateWebhookOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this webhook service create webhook o k response has a 3xx status code
func (o *WebhookServiceCreateWebhookOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this webhook service create webhook o k response has a 4xx status code
func (o *WebhookServiceCreateWebhookOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this webhook service create webhook o k response has a 5xx status code
func (o *WebhookServiceCreateWebhookOK) IsServerError() bool {
	return false
}

// IsCode returns true when this webhook service create webhook o k response a status code equal to that given
func (o *WebhookServiceCreateWebhookOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the webhook service create webhook o k response
func (o *WebhookServiceCreateWebhookOK) Code() int {
	return 200
}

func (o *WebhookServiceCreateWebhookOK) Error() string {
	return fmt.Sprintf("[POST /2023-05-31/webhook/{parent_resource_name}/webhooks][%d] webhookServiceCreateWebhookOK  %+v", 200, o.Payload)
}

func (o *WebhookServiceCreateWebhookOK) String() string {
	return fmt.Sprintf("[POST /2023-05-31/webhook/{parent_resource_name}/webhooks][%d] webhookServiceCreateWebhookOK  %+v", 200, o.Payload)
}

func (o *WebhookServiceCreateWebhookOK) GetPayload() *models.HashicorpCloudWebhookCreateWebhookResponse {
	return o.Payload
}

func (o *WebhookServiceCreateWebhookOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWebhookCreateWebhookResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWebhookServiceCreateWebhookDefault creates a WebhookServiceCreateWebhookDefault with default headers values
func NewWebhookServiceCreateWebhookDefault(code int) *WebhookServiceCreateWebhookDefault {
	return &WebhookServiceCreateWebhookDefault{
		_statusCode: code,
	}
}

/*
WebhookServiceCreateWebhookDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WebhookServiceCreateWebhookDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this webhook service create webhook default response has a 2xx status code
func (o *WebhookServiceCreateWebhookDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this webhook service create webhook default response has a 3xx status code
func (o *WebhookServiceCreateWebhookDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this webhook service create webhook default response has a 4xx status code
func (o *WebhookServiceCreateWebhookDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this webhook service create webhook default response has a 5xx status code
func (o *WebhookServiceCreateWebhookDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this webhook service create webhook default response a status code equal to that given
func (o *WebhookServiceCreateWebhookDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the webhook service create webhook default response
func (o *WebhookServiceCreateWebhookDefault) Code() int {
	return o._statusCode
}

func (o *WebhookServiceCreateWebhookDefault) Error() string {
	return fmt.Sprintf("[POST /2023-05-31/webhook/{parent_resource_name}/webhooks][%d] WebhookService_CreateWebhook default  %+v", o._statusCode, o.Payload)
}

func (o *WebhookServiceCreateWebhookDefault) String() string {
	return fmt.Sprintf("[POST /2023-05-31/webhook/{parent_resource_name}/webhooks][%d] WebhookService_CreateWebhook default  %+v", o._statusCode, o.Payload)
}

func (o *WebhookServiceCreateWebhookDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WebhookServiceCreateWebhookDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
