// Code generated by go-swagger; DO NOT EDIT.

package webhook_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-webhook/stable/2023-05-31/models"
)

// NewWebhookServiceUpdateWebhookNameParams creates a new WebhookServiceUpdateWebhookNameParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWebhookServiceUpdateWebhookNameParams() *WebhookServiceUpdateWebhookNameParams {
	return &WebhookServiceUpdateWebhookNameParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWebhookServiceUpdateWebhookNameParamsWithTimeout creates a new WebhookServiceUpdateWebhookNameParams object
// with the ability to set a timeout on a request.
func NewWebhookServiceUpdateWebhookNameParamsWithTimeout(timeout time.Duration) *WebhookServiceUpdateWebhookNameParams {
	return &WebhookServiceUpdateWebhookNameParams{
		timeout: timeout,
	}
}

// NewWebhookServiceUpdateWebhookNameParamsWithContext creates a new WebhookServiceUpdateWebhookNameParams object
// with the ability to set a context for a request.
func NewWebhookServiceUpdateWebhookNameParamsWithContext(ctx context.Context) *WebhookServiceUpdateWebhookNameParams {
	return &WebhookServiceUpdateWebhookNameParams{
		Context: ctx,
	}
}

// NewWebhookServiceUpdateWebhookNameParamsWithHTTPClient creates a new WebhookServiceUpdateWebhookNameParams object
// with the ability to set a custom HTTPClient for a request.
func NewWebhookServiceUpdateWebhookNameParamsWithHTTPClient(client *http.Client) *WebhookServiceUpdateWebhookNameParams {
	return &WebhookServiceUpdateWebhookNameParams{
		HTTPClient: client,
	}
}

/*
WebhookServiceUpdateWebhookNameParams contains all the parameters to send to the API endpoint

	for the webhook service update webhook name operation.

	Typically these are written to a http.Request.
*/
type WebhookServiceUpdateWebhookNameParams struct {

	/* Body.

	   The information to update a webhook name.
	*/
	Body *models.HashicorpCloudWebhookUpdateWebhookNameRequestBody

	/* ResourceName.

	     The webhook resource name.
	A webhook's resource name format name is `webhook/project/<project-id>/geo/<geography>/webhook/<webhook-name>`.
	*/
	ResourceName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the webhook service update webhook name params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebhookServiceUpdateWebhookNameParams) WithDefaults() *WebhookServiceUpdateWebhookNameParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the webhook service update webhook name params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WebhookServiceUpdateWebhookNameParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the webhook service update webhook name params
func (o *WebhookServiceUpdateWebhookNameParams) WithTimeout(timeout time.Duration) *WebhookServiceUpdateWebhookNameParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the webhook service update webhook name params
func (o *WebhookServiceUpdateWebhookNameParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the webhook service update webhook name params
func (o *WebhookServiceUpdateWebhookNameParams) WithContext(ctx context.Context) *WebhookServiceUpdateWebhookNameParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the webhook service update webhook name params
func (o *WebhookServiceUpdateWebhookNameParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the webhook service update webhook name params
func (o *WebhookServiceUpdateWebhookNameParams) WithHTTPClient(client *http.Client) *WebhookServiceUpdateWebhookNameParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the webhook service update webhook name params
func (o *WebhookServiceUpdateWebhookNameParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the webhook service update webhook name params
func (o *WebhookServiceUpdateWebhookNameParams) WithBody(body *models.HashicorpCloudWebhookUpdateWebhookNameRequestBody) *WebhookServiceUpdateWebhookNameParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the webhook service update webhook name params
func (o *WebhookServiceUpdateWebhookNameParams) SetBody(body *models.HashicorpCloudWebhookUpdateWebhookNameRequestBody) {
	o.Body = body
}

// WithResourceName adds the resourceName to the webhook service update webhook name params
func (o *WebhookServiceUpdateWebhookNameParams) WithResourceName(resourceName string) *WebhookServiceUpdateWebhookNameParams {
	o.SetResourceName(resourceName)
	return o
}

// SetResourceName adds the resourceName to the webhook service update webhook name params
func (o *WebhookServiceUpdateWebhookNameParams) SetResourceName(resourceName string) {
	o.ResourceName = resourceName
}

// WriteToRequest writes these params to a swagger request
func (o *WebhookServiceUpdateWebhookNameParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param resource_name
	if err := r.SetPathParam("resource_name", o.ResourceName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
