// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// AddTeamRoleReader is a Reader for the AddTeamRole structure.
type AddTeamRoleReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *AddTeamRoleReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewAddTeamRoleOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewAddTeamRoleBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewAddTeamRoleForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewAddTeamRoleNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewAddTeamRoleInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /access-control/teams/{teamId}/roles] addTeamRole", response, response.Code())
	}
}

// NewAddTeamRoleOK creates a AddTeamRoleOK with default headers values
func NewAddTeamRoleOK() *AddTeamRoleOK {
	return &AddTeamRoleOK{}
}

/*
AddTeamRoleOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type AddTeamRoleOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this add team role Ok response has a 2xx status code
func (o *AddTeamRoleOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this add team role Ok response has a 3xx status code
func (o *AddTeamRoleOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add team role Ok response has a 4xx status code
func (o *AddTeamRoleOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this add team role Ok response has a 5xx status code
func (o *AddTeamRoleOK) IsServerError() bool {
	return false
}

// IsCode returns true when this add team role Ok response a status code equal to that given
func (o *AddTeamRoleOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the add team role Ok response
func (o *AddTeamRoleOK) Code() int {
	return 200
}

func (o *AddTeamRoleOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/{teamId}/roles][%d] addTeamRoleOk %s", 200, payload)
}

func (o *AddTeamRoleOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/{teamId}/roles][%d] addTeamRoleOk %s", 200, payload)
}

func (o *AddTeamRoleOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *AddTeamRoleOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddTeamRoleBadRequest creates a AddTeamRoleBadRequest with default headers values
func NewAddTeamRoleBadRequest() *AddTeamRoleBadRequest {
	return &AddTeamRoleBadRequest{}
}

/*
AddTeamRoleBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type AddTeamRoleBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this add team role bad request response has a 2xx status code
func (o *AddTeamRoleBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add team role bad request response has a 3xx status code
func (o *AddTeamRoleBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add team role bad request response has a 4xx status code
func (o *AddTeamRoleBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this add team role bad request response has a 5xx status code
func (o *AddTeamRoleBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this add team role bad request response a status code equal to that given
func (o *AddTeamRoleBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the add team role bad request response
func (o *AddTeamRoleBadRequest) Code() int {
	return 400
}

func (o *AddTeamRoleBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/{teamId}/roles][%d] addTeamRoleBadRequest %s", 400, payload)
}

func (o *AddTeamRoleBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/{teamId}/roles][%d] addTeamRoleBadRequest %s", 400, payload)
}

func (o *AddTeamRoleBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AddTeamRoleBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddTeamRoleForbidden creates a AddTeamRoleForbidden with default headers values
func NewAddTeamRoleForbidden() *AddTeamRoleForbidden {
	return &AddTeamRoleForbidden{}
}

/*
AddTeamRoleForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type AddTeamRoleForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this add team role forbidden response has a 2xx status code
func (o *AddTeamRoleForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add team role forbidden response has a 3xx status code
func (o *AddTeamRoleForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add team role forbidden response has a 4xx status code
func (o *AddTeamRoleForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this add team role forbidden response has a 5xx status code
func (o *AddTeamRoleForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this add team role forbidden response a status code equal to that given
func (o *AddTeamRoleForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the add team role forbidden response
func (o *AddTeamRoleForbidden) Code() int {
	return 403
}

func (o *AddTeamRoleForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/{teamId}/roles][%d] addTeamRoleForbidden %s", 403, payload)
}

func (o *AddTeamRoleForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/{teamId}/roles][%d] addTeamRoleForbidden %s", 403, payload)
}

func (o *AddTeamRoleForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AddTeamRoleForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddTeamRoleNotFound creates a AddTeamRoleNotFound with default headers values
func NewAddTeamRoleNotFound() *AddTeamRoleNotFound {
	return &AddTeamRoleNotFound{}
}

/*
AddTeamRoleNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type AddTeamRoleNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this add team role not found response has a 2xx status code
func (o *AddTeamRoleNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add team role not found response has a 3xx status code
func (o *AddTeamRoleNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add team role not found response has a 4xx status code
func (o *AddTeamRoleNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this add team role not found response has a 5xx status code
func (o *AddTeamRoleNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this add team role not found response a status code equal to that given
func (o *AddTeamRoleNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the add team role not found response
func (o *AddTeamRoleNotFound) Code() int {
	return 404
}

func (o *AddTeamRoleNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/{teamId}/roles][%d] addTeamRoleNotFound %s", 404, payload)
}

func (o *AddTeamRoleNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/{teamId}/roles][%d] addTeamRoleNotFound %s", 404, payload)
}

func (o *AddTeamRoleNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AddTeamRoleNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewAddTeamRoleInternalServerError creates a AddTeamRoleInternalServerError with default headers values
func NewAddTeamRoleInternalServerError() *AddTeamRoleInternalServerError {
	return &AddTeamRoleInternalServerError{}
}

/*
AddTeamRoleInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type AddTeamRoleInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this add team role internal server error response has a 2xx status code
func (o *AddTeamRoleInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this add team role internal server error response has a 3xx status code
func (o *AddTeamRoleInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this add team role internal server error response has a 4xx status code
func (o *AddTeamRoleInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this add team role internal server error response has a 5xx status code
func (o *AddTeamRoleInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this add team role internal server error response a status code equal to that given
func (o *AddTeamRoleInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the add team role internal server error response
func (o *AddTeamRoleInternalServerError) Code() int {
	return 500
}

func (o *AddTeamRoleInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/{teamId}/roles][%d] addTeamRoleInternalServerError %s", 500, payload)
}

func (o *AddTeamRoleInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /access-control/teams/{teamId}/roles][%d] addTeamRoleInternalServerError %s", 500, payload)
}

func (o *AddTeamRoleInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *AddTeamRoleInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
