// Code generated by go-swagger; DO NOT EDIT.

package admin_users

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateUserQuotaReader is a Reader for the UpdateUserQuota structure.
type UpdateUserQuotaReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateUserQuotaReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateUserQuotaOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewUpdateUserQuotaUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateUserQuotaForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateUserQuotaNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateUserQuotaInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /admin/users/{user_id}/quotas/{quota_target}] updateUserQuota", response, response.Code())
	}
}

// NewUpdateUserQuotaOK creates a UpdateUserQuotaOK with default headers values
func NewUpdateUserQuotaOK() *UpdateUserQuotaOK {
	return &UpdateUserQuotaOK{}
}

/*
UpdateUserQuotaOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type UpdateUserQuotaOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this update user quota Ok response has a 2xx status code
func (o *UpdateUserQuotaOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update user quota Ok response has a 3xx status code
func (o *UpdateUserQuotaOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user quota Ok response has a 4xx status code
func (o *UpdateUserQuotaOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update user quota Ok response has a 5xx status code
func (o *UpdateUserQuotaOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update user quota Ok response a status code equal to that given
func (o *UpdateUserQuotaOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update user quota Ok response
func (o *UpdateUserQuotaOK) Code() int {
	return 200
}

func (o *UpdateUserQuotaOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /admin/users/{user_id}/quotas/{quota_target}][%d] updateUserQuotaOk %s", 200, payload)
}

func (o *UpdateUserQuotaOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /admin/users/{user_id}/quotas/{quota_target}][%d] updateUserQuotaOk %s", 200, payload)
}

func (o *UpdateUserQuotaOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *UpdateUserQuotaOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserQuotaUnauthorized creates a UpdateUserQuotaUnauthorized with default headers values
func NewUpdateUserQuotaUnauthorized() *UpdateUserQuotaUnauthorized {
	return &UpdateUserQuotaUnauthorized{}
}

/*
UpdateUserQuotaUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateUserQuotaUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update user quota unauthorized response has a 2xx status code
func (o *UpdateUserQuotaUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user quota unauthorized response has a 3xx status code
func (o *UpdateUserQuotaUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user quota unauthorized response has a 4xx status code
func (o *UpdateUserQuotaUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update user quota unauthorized response has a 5xx status code
func (o *UpdateUserQuotaUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update user quota unauthorized response a status code equal to that given
func (o *UpdateUserQuotaUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update user quota unauthorized response
func (o *UpdateUserQuotaUnauthorized) Code() int {
	return 401
}

func (o *UpdateUserQuotaUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /admin/users/{user_id}/quotas/{quota_target}][%d] updateUserQuotaUnauthorized %s", 401, payload)
}

func (o *UpdateUserQuotaUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /admin/users/{user_id}/quotas/{quota_target}][%d] updateUserQuotaUnauthorized %s", 401, payload)
}

func (o *UpdateUserQuotaUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateUserQuotaUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserQuotaForbidden creates a UpdateUserQuotaForbidden with default headers values
func NewUpdateUserQuotaForbidden() *UpdateUserQuotaForbidden {
	return &UpdateUserQuotaForbidden{}
}

/*
UpdateUserQuotaForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateUserQuotaForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update user quota forbidden response has a 2xx status code
func (o *UpdateUserQuotaForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user quota forbidden response has a 3xx status code
func (o *UpdateUserQuotaForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user quota forbidden response has a 4xx status code
func (o *UpdateUserQuotaForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update user quota forbidden response has a 5xx status code
func (o *UpdateUserQuotaForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update user quota forbidden response a status code equal to that given
func (o *UpdateUserQuotaForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update user quota forbidden response
func (o *UpdateUserQuotaForbidden) Code() int {
	return 403
}

func (o *UpdateUserQuotaForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /admin/users/{user_id}/quotas/{quota_target}][%d] updateUserQuotaForbidden %s", 403, payload)
}

func (o *UpdateUserQuotaForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /admin/users/{user_id}/quotas/{quota_target}][%d] updateUserQuotaForbidden %s", 403, payload)
}

func (o *UpdateUserQuotaForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateUserQuotaForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserQuotaNotFound creates a UpdateUserQuotaNotFound with default headers values
func NewUpdateUserQuotaNotFound() *UpdateUserQuotaNotFound {
	return &UpdateUserQuotaNotFound{}
}

/*
UpdateUserQuotaNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type UpdateUserQuotaNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update user quota not found response has a 2xx status code
func (o *UpdateUserQuotaNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user quota not found response has a 3xx status code
func (o *UpdateUserQuotaNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user quota not found response has a 4xx status code
func (o *UpdateUserQuotaNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update user quota not found response has a 5xx status code
func (o *UpdateUserQuotaNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update user quota not found response a status code equal to that given
func (o *UpdateUserQuotaNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update user quota not found response
func (o *UpdateUserQuotaNotFound) Code() int {
	return 404
}

func (o *UpdateUserQuotaNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /admin/users/{user_id}/quotas/{quota_target}][%d] updateUserQuotaNotFound %s", 404, payload)
}

func (o *UpdateUserQuotaNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /admin/users/{user_id}/quotas/{quota_target}][%d] updateUserQuotaNotFound %s", 404, payload)
}

func (o *UpdateUserQuotaNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateUserQuotaNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateUserQuotaInternalServerError creates a UpdateUserQuotaInternalServerError with default headers values
func NewUpdateUserQuotaInternalServerError() *UpdateUserQuotaInternalServerError {
	return &UpdateUserQuotaInternalServerError{}
}

/*
UpdateUserQuotaInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateUserQuotaInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update user quota internal server error response has a 2xx status code
func (o *UpdateUserQuotaInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update user quota internal server error response has a 3xx status code
func (o *UpdateUserQuotaInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update user quota internal server error response has a 4xx status code
func (o *UpdateUserQuotaInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update user quota internal server error response has a 5xx status code
func (o *UpdateUserQuotaInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update user quota internal server error response a status code equal to that given
func (o *UpdateUserQuotaInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update user quota internal server error response
func (o *UpdateUserQuotaInternalServerError) Code() int {
	return 500
}

func (o *UpdateUserQuotaInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /admin/users/{user_id}/quotas/{quota_target}][%d] updateUserQuotaInternalServerError %s", 500, payload)
}

func (o *UpdateUserQuotaInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /admin/users/{user_id}/quotas/{quota_target}][%d] updateUserQuotaInternalServerError %s", 500, payload)
}

func (o *UpdateUserQuotaInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateUserQuotaInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
