// Code generated by go-swagger; DO NOT EDIT.

package annotations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewPatchAnnotationParams creates a new PatchAnnotationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPatchAnnotationParams() *PatchAnnotationParams {
	return &PatchAnnotationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPatchAnnotationParamsWithTimeout creates a new PatchAnnotationParams object
// with the ability to set a timeout on a request.
func NewPatchAnnotationParamsWithTimeout(timeout time.Duration) *PatchAnnotationParams {
	return &PatchAnnotationParams{
		timeout: timeout,
	}
}

// NewPatchAnnotationParamsWithContext creates a new PatchAnnotationParams object
// with the ability to set a context for a request.
func NewPatchAnnotationParamsWithContext(ctx context.Context) *PatchAnnotationParams {
	return &PatchAnnotationParams{
		Context: ctx,
	}
}

// NewPatchAnnotationParamsWithHTTPClient creates a new PatchAnnotationParams object
// with the ability to set a custom HTTPClient for a request.
func NewPatchAnnotationParamsWithHTTPClient(client *http.Client) *PatchAnnotationParams {
	return &PatchAnnotationParams{
		HTTPClient: client,
	}
}

/*
PatchAnnotationParams contains all the parameters to send to the API endpoint

	for the patch annotation operation.

	Typically these are written to a http.Request.
*/
type PatchAnnotationParams struct {

	// AnnotationID.
	AnnotationID string

	// Body.
	Body *models.PatchAnnotationsCmd

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the patch annotation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PatchAnnotationParams) WithDefaults() *PatchAnnotationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the patch annotation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PatchAnnotationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the patch annotation params
func (o *PatchAnnotationParams) WithTimeout(timeout time.Duration) *PatchAnnotationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the patch annotation params
func (o *PatchAnnotationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the patch annotation params
func (o *PatchAnnotationParams) WithContext(ctx context.Context) *PatchAnnotationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the patch annotation params
func (o *PatchAnnotationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the patch annotation params
func (o *PatchAnnotationParams) WithHTTPClient(client *http.Client) *PatchAnnotationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the patch annotation params
func (o *PatchAnnotationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAnnotationID adds the annotationID to the patch annotation params
func (o *PatchAnnotationParams) WithAnnotationID(annotationID string) *PatchAnnotationParams {
	o.SetAnnotationID(annotationID)
	return o
}

// SetAnnotationID adds the annotationId to the patch annotation params
func (o *PatchAnnotationParams) SetAnnotationID(annotationID string) {
	o.AnnotationID = annotationID
}

// WithBody adds the body to the patch annotation params
func (o *PatchAnnotationParams) WithBody(body *models.PatchAnnotationsCmd) *PatchAnnotationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the patch annotation params
func (o *PatchAnnotationParams) SetBody(body *models.PatchAnnotationsCmd) {
	o.Body = body
}

// WriteToRequest writes these params to a swagger request
func (o *PatchAnnotationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param annotation_id
	if err := r.SetPathParam("annotation_id", o.AnnotationID); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
