// Code generated by go-swagger; DO NOT EDIT.

package annotations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// PostAnnotationReader is a Reader for the PostAnnotation structure.
type PostAnnotationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PostAnnotationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPostAnnotationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPostAnnotationBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewPostAnnotationUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewPostAnnotationForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewPostAnnotationInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /annotations] postAnnotation", response, response.Code())
	}
}

// NewPostAnnotationOK creates a PostAnnotationOK with default headers values
func NewPostAnnotationOK() *PostAnnotationOK {
	return &PostAnnotationOK{}
}

/*
PostAnnotationOK describes a response with status code 200, with default header values.

(empty)
*/
type PostAnnotationOK struct {
	Payload *models.PostAnnotationOKBody
}

// IsSuccess returns true when this post annotation Ok response has a 2xx status code
func (o *PostAnnotationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this post annotation Ok response has a 3xx status code
func (o *PostAnnotationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post annotation Ok response has a 4xx status code
func (o *PostAnnotationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this post annotation Ok response has a 5xx status code
func (o *PostAnnotationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this post annotation Ok response a status code equal to that given
func (o *PostAnnotationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the post annotation Ok response
func (o *PostAnnotationOK) Code() int {
	return 200
}

func (o *PostAnnotationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /annotations][%d] postAnnotationOk %s", 200, payload)
}

func (o *PostAnnotationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /annotations][%d] postAnnotationOk %s", 200, payload)
}

func (o *PostAnnotationOK) GetPayload() *models.PostAnnotationOKBody {
	return o.Payload
}

func (o *PostAnnotationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PostAnnotationOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostAnnotationBadRequest creates a PostAnnotationBadRequest with default headers values
func NewPostAnnotationBadRequest() *PostAnnotationBadRequest {
	return &PostAnnotationBadRequest{}
}

/*
PostAnnotationBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type PostAnnotationBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post annotation bad request response has a 2xx status code
func (o *PostAnnotationBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post annotation bad request response has a 3xx status code
func (o *PostAnnotationBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post annotation bad request response has a 4xx status code
func (o *PostAnnotationBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this post annotation bad request response has a 5xx status code
func (o *PostAnnotationBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this post annotation bad request response a status code equal to that given
func (o *PostAnnotationBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the post annotation bad request response
func (o *PostAnnotationBadRequest) Code() int {
	return 400
}

func (o *PostAnnotationBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /annotations][%d] postAnnotationBadRequest %s", 400, payload)
}

func (o *PostAnnotationBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /annotations][%d] postAnnotationBadRequest %s", 400, payload)
}

func (o *PostAnnotationBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostAnnotationBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostAnnotationUnauthorized creates a PostAnnotationUnauthorized with default headers values
func NewPostAnnotationUnauthorized() *PostAnnotationUnauthorized {
	return &PostAnnotationUnauthorized{}
}

/*
PostAnnotationUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type PostAnnotationUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post annotation unauthorized response has a 2xx status code
func (o *PostAnnotationUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post annotation unauthorized response has a 3xx status code
func (o *PostAnnotationUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post annotation unauthorized response has a 4xx status code
func (o *PostAnnotationUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this post annotation unauthorized response has a 5xx status code
func (o *PostAnnotationUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this post annotation unauthorized response a status code equal to that given
func (o *PostAnnotationUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the post annotation unauthorized response
func (o *PostAnnotationUnauthorized) Code() int {
	return 401
}

func (o *PostAnnotationUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /annotations][%d] postAnnotationUnauthorized %s", 401, payload)
}

func (o *PostAnnotationUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /annotations][%d] postAnnotationUnauthorized %s", 401, payload)
}

func (o *PostAnnotationUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostAnnotationUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostAnnotationForbidden creates a PostAnnotationForbidden with default headers values
func NewPostAnnotationForbidden() *PostAnnotationForbidden {
	return &PostAnnotationForbidden{}
}

/*
PostAnnotationForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type PostAnnotationForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post annotation forbidden response has a 2xx status code
func (o *PostAnnotationForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post annotation forbidden response has a 3xx status code
func (o *PostAnnotationForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post annotation forbidden response has a 4xx status code
func (o *PostAnnotationForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this post annotation forbidden response has a 5xx status code
func (o *PostAnnotationForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this post annotation forbidden response a status code equal to that given
func (o *PostAnnotationForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the post annotation forbidden response
func (o *PostAnnotationForbidden) Code() int {
	return 403
}

func (o *PostAnnotationForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /annotations][%d] postAnnotationForbidden %s", 403, payload)
}

func (o *PostAnnotationForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /annotations][%d] postAnnotationForbidden %s", 403, payload)
}

func (o *PostAnnotationForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostAnnotationForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPostAnnotationInternalServerError creates a PostAnnotationInternalServerError with default headers values
func NewPostAnnotationInternalServerError() *PostAnnotationInternalServerError {
	return &PostAnnotationInternalServerError{}
}

/*
PostAnnotationInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type PostAnnotationInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this post annotation internal server error response has a 2xx status code
func (o *PostAnnotationInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this post annotation internal server error response has a 3xx status code
func (o *PostAnnotationInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this post annotation internal server error response has a 4xx status code
func (o *PostAnnotationInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this post annotation internal server error response has a 5xx status code
func (o *PostAnnotationInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this post annotation internal server error response a status code equal to that given
func (o *PostAnnotationInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the post annotation internal server error response
func (o *PostAnnotationInternalServerError) Code() int {
	return 500
}

func (o *PostAnnotationInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /annotations][%d] postAnnotationInternalServerError %s", 500, payload)
}

func (o *PostAnnotationInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /annotations][%d] postAnnotationInternalServerError %s", 500, payload)
}

func (o *PostAnnotationInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *PostAnnotationInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
