// Code generated by go-swagger; DO NOT EDIT.

package folders

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateFolderReader is a Reader for the UpdateFolder structure.
type UpdateFolderReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateFolderReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateFolderOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateFolderBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUpdateFolderUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateFolderForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateFolderNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewUpdateFolderConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateFolderInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /folders/{folder_uid}] updateFolder", response, response.Code())
	}
}

// NewUpdateFolderOK creates a UpdateFolderOK with default headers values
func NewUpdateFolderOK() *UpdateFolderOK {
	return &UpdateFolderOK{}
}

/*
UpdateFolderOK describes a response with status code 200, with default header values.

(empty)
*/
type UpdateFolderOK struct {
	Payload *models.Folder
}

// IsSuccess returns true when this update folder Ok response has a 2xx status code
func (o *UpdateFolderOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update folder Ok response has a 3xx status code
func (o *UpdateFolderOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update folder Ok response has a 4xx status code
func (o *UpdateFolderOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update folder Ok response has a 5xx status code
func (o *UpdateFolderOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update folder Ok response a status code equal to that given
func (o *UpdateFolderOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update folder Ok response
func (o *UpdateFolderOK) Code() int {
	return 200
}

func (o *UpdateFolderOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderOk %s", 200, payload)
}

func (o *UpdateFolderOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderOk %s", 200, payload)
}

func (o *UpdateFolderOK) GetPayload() *models.Folder {
	return o.Payload
}

func (o *UpdateFolderOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Folder)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFolderBadRequest creates a UpdateFolderBadRequest with default headers values
func NewUpdateFolderBadRequest() *UpdateFolderBadRequest {
	return &UpdateFolderBadRequest{}
}

/*
UpdateFolderBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type UpdateFolderBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update folder bad request response has a 2xx status code
func (o *UpdateFolderBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update folder bad request response has a 3xx status code
func (o *UpdateFolderBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update folder bad request response has a 4xx status code
func (o *UpdateFolderBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update folder bad request response has a 5xx status code
func (o *UpdateFolderBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update folder bad request response a status code equal to that given
func (o *UpdateFolderBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update folder bad request response
func (o *UpdateFolderBadRequest) Code() int {
	return 400
}

func (o *UpdateFolderBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderBadRequest %s", 400, payload)
}

func (o *UpdateFolderBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderBadRequest %s", 400, payload)
}

func (o *UpdateFolderBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateFolderBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFolderUnauthorized creates a UpdateFolderUnauthorized with default headers values
func NewUpdateFolderUnauthorized() *UpdateFolderUnauthorized {
	return &UpdateFolderUnauthorized{}
}

/*
UpdateFolderUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateFolderUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update folder unauthorized response has a 2xx status code
func (o *UpdateFolderUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update folder unauthorized response has a 3xx status code
func (o *UpdateFolderUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update folder unauthorized response has a 4xx status code
func (o *UpdateFolderUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update folder unauthorized response has a 5xx status code
func (o *UpdateFolderUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update folder unauthorized response a status code equal to that given
func (o *UpdateFolderUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update folder unauthorized response
func (o *UpdateFolderUnauthorized) Code() int {
	return 401
}

func (o *UpdateFolderUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderUnauthorized %s", 401, payload)
}

func (o *UpdateFolderUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderUnauthorized %s", 401, payload)
}

func (o *UpdateFolderUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateFolderUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFolderForbidden creates a UpdateFolderForbidden with default headers values
func NewUpdateFolderForbidden() *UpdateFolderForbidden {
	return &UpdateFolderForbidden{}
}

/*
UpdateFolderForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateFolderForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update folder forbidden response has a 2xx status code
func (o *UpdateFolderForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update folder forbidden response has a 3xx status code
func (o *UpdateFolderForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update folder forbidden response has a 4xx status code
func (o *UpdateFolderForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update folder forbidden response has a 5xx status code
func (o *UpdateFolderForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update folder forbidden response a status code equal to that given
func (o *UpdateFolderForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update folder forbidden response
func (o *UpdateFolderForbidden) Code() int {
	return 403
}

func (o *UpdateFolderForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderForbidden %s", 403, payload)
}

func (o *UpdateFolderForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderForbidden %s", 403, payload)
}

func (o *UpdateFolderForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateFolderForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFolderNotFound creates a UpdateFolderNotFound with default headers values
func NewUpdateFolderNotFound() *UpdateFolderNotFound {
	return &UpdateFolderNotFound{}
}

/*
UpdateFolderNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type UpdateFolderNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update folder not found response has a 2xx status code
func (o *UpdateFolderNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update folder not found response has a 3xx status code
func (o *UpdateFolderNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update folder not found response has a 4xx status code
func (o *UpdateFolderNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update folder not found response has a 5xx status code
func (o *UpdateFolderNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update folder not found response a status code equal to that given
func (o *UpdateFolderNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update folder not found response
func (o *UpdateFolderNotFound) Code() int {
	return 404
}

func (o *UpdateFolderNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderNotFound %s", 404, payload)
}

func (o *UpdateFolderNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderNotFound %s", 404, payload)
}

func (o *UpdateFolderNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateFolderNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFolderConflict creates a UpdateFolderConflict with default headers values
func NewUpdateFolderConflict() *UpdateFolderConflict {
	return &UpdateFolderConflict{}
}

/*
UpdateFolderConflict describes a response with status code 409, with default header values.

ConflictError
*/
type UpdateFolderConflict struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update folder conflict response has a 2xx status code
func (o *UpdateFolderConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update folder conflict response has a 3xx status code
func (o *UpdateFolderConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update folder conflict response has a 4xx status code
func (o *UpdateFolderConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this update folder conflict response has a 5xx status code
func (o *UpdateFolderConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this update folder conflict response a status code equal to that given
func (o *UpdateFolderConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the update folder conflict response
func (o *UpdateFolderConflict) Code() int {
	return 409
}

func (o *UpdateFolderConflict) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderConflict %s", 409, payload)
}

func (o *UpdateFolderConflict) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderConflict %s", 409, payload)
}

func (o *UpdateFolderConflict) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateFolderConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateFolderInternalServerError creates a UpdateFolderInternalServerError with default headers values
func NewUpdateFolderInternalServerError() *UpdateFolderInternalServerError {
	return &UpdateFolderInternalServerError{}
}

/*
UpdateFolderInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateFolderInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update folder internal server error response has a 2xx status code
func (o *UpdateFolderInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update folder internal server error response has a 3xx status code
func (o *UpdateFolderInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update folder internal server error response has a 4xx status code
func (o *UpdateFolderInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update folder internal server error response has a 5xx status code
func (o *UpdateFolderInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update folder internal server error response a status code equal to that given
func (o *UpdateFolderInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update folder internal server error response
func (o *UpdateFolderInternalServerError) Code() int {
	return 500
}

func (o *UpdateFolderInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderInternalServerError %s", 500, payload)
}

func (o *UpdateFolderInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /folders/{folder_uid}][%d] updateFolderInternalServerError %s", 500, payload)
}

func (o *UpdateFolderInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateFolderInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
