// Code generated by go-swagger; DO NOT EDIT.

package group_attribute_sync

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetGroupRolesReader is a Reader for the GetGroupRoles structure.
type GetGroupRolesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetGroupRolesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetGroupRolesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetGroupRolesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetGroupRolesUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetGroupRolesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetGroupRolesNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetGroupRolesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /groupsync/groups/{group_id}/roles] getGroupRoles", response, response.Code())
	}
}

// NewGetGroupRolesOK creates a GetGroupRolesOK with default headers values
func NewGetGroupRolesOK() *GetGroupRolesOK {
	return &GetGroupRolesOK{}
}

/*
GetGroupRolesOK describes a response with status code 200, with default header values.

(empty)
*/
type GetGroupRolesOK struct {
	Payload []*models.RoleDTO
}

// IsSuccess returns true when this get group roles Ok response has a 2xx status code
func (o *GetGroupRolesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get group roles Ok response has a 3xx status code
func (o *GetGroupRolesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get group roles Ok response has a 4xx status code
func (o *GetGroupRolesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get group roles Ok response has a 5xx status code
func (o *GetGroupRolesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get group roles Ok response a status code equal to that given
func (o *GetGroupRolesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get group roles Ok response
func (o *GetGroupRolesOK) Code() int {
	return 200
}

func (o *GetGroupRolesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups/{group_id}/roles][%d] getGroupRolesOk %s", 200, payload)
}

func (o *GetGroupRolesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups/{group_id}/roles][%d] getGroupRolesOk %s", 200, payload)
}

func (o *GetGroupRolesOK) GetPayload() []*models.RoleDTO {
	return o.Payload
}

func (o *GetGroupRolesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupRolesBadRequest creates a GetGroupRolesBadRequest with default headers values
func NewGetGroupRolesBadRequest() *GetGroupRolesBadRequest {
	return &GetGroupRolesBadRequest{}
}

/*
GetGroupRolesBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type GetGroupRolesBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get group roles bad request response has a 2xx status code
func (o *GetGroupRolesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get group roles bad request response has a 3xx status code
func (o *GetGroupRolesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get group roles bad request response has a 4xx status code
func (o *GetGroupRolesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get group roles bad request response has a 5xx status code
func (o *GetGroupRolesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get group roles bad request response a status code equal to that given
func (o *GetGroupRolesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get group roles bad request response
func (o *GetGroupRolesBadRequest) Code() int {
	return 400
}

func (o *GetGroupRolesBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups/{group_id}/roles][%d] getGroupRolesBadRequest %s", 400, payload)
}

func (o *GetGroupRolesBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups/{group_id}/roles][%d] getGroupRolesBadRequest %s", 400, payload)
}

func (o *GetGroupRolesBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetGroupRolesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupRolesUnauthorized creates a GetGroupRolesUnauthorized with default headers values
func NewGetGroupRolesUnauthorized() *GetGroupRolesUnauthorized {
	return &GetGroupRolesUnauthorized{}
}

/*
GetGroupRolesUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetGroupRolesUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get group roles unauthorized response has a 2xx status code
func (o *GetGroupRolesUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get group roles unauthorized response has a 3xx status code
func (o *GetGroupRolesUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get group roles unauthorized response has a 4xx status code
func (o *GetGroupRolesUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get group roles unauthorized response has a 5xx status code
func (o *GetGroupRolesUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get group roles unauthorized response a status code equal to that given
func (o *GetGroupRolesUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get group roles unauthorized response
func (o *GetGroupRolesUnauthorized) Code() int {
	return 401
}

func (o *GetGroupRolesUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups/{group_id}/roles][%d] getGroupRolesUnauthorized %s", 401, payload)
}

func (o *GetGroupRolesUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups/{group_id}/roles][%d] getGroupRolesUnauthorized %s", 401, payload)
}

func (o *GetGroupRolesUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetGroupRolesUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupRolesForbidden creates a GetGroupRolesForbidden with default headers values
func NewGetGroupRolesForbidden() *GetGroupRolesForbidden {
	return &GetGroupRolesForbidden{}
}

/*
GetGroupRolesForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetGroupRolesForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get group roles forbidden response has a 2xx status code
func (o *GetGroupRolesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get group roles forbidden response has a 3xx status code
func (o *GetGroupRolesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get group roles forbidden response has a 4xx status code
func (o *GetGroupRolesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get group roles forbidden response has a 5xx status code
func (o *GetGroupRolesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get group roles forbidden response a status code equal to that given
func (o *GetGroupRolesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get group roles forbidden response
func (o *GetGroupRolesForbidden) Code() int {
	return 403
}

func (o *GetGroupRolesForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups/{group_id}/roles][%d] getGroupRolesForbidden %s", 403, payload)
}

func (o *GetGroupRolesForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups/{group_id}/roles][%d] getGroupRolesForbidden %s", 403, payload)
}

func (o *GetGroupRolesForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetGroupRolesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupRolesNotFound creates a GetGroupRolesNotFound with default headers values
func NewGetGroupRolesNotFound() *GetGroupRolesNotFound {
	return &GetGroupRolesNotFound{}
}

/*
GetGroupRolesNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetGroupRolesNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get group roles not found response has a 2xx status code
func (o *GetGroupRolesNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get group roles not found response has a 3xx status code
func (o *GetGroupRolesNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get group roles not found response has a 4xx status code
func (o *GetGroupRolesNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get group roles not found response has a 5xx status code
func (o *GetGroupRolesNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get group roles not found response a status code equal to that given
func (o *GetGroupRolesNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get group roles not found response
func (o *GetGroupRolesNotFound) Code() int {
	return 404
}

func (o *GetGroupRolesNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups/{group_id}/roles][%d] getGroupRolesNotFound %s", 404, payload)
}

func (o *GetGroupRolesNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups/{group_id}/roles][%d] getGroupRolesNotFound %s", 404, payload)
}

func (o *GetGroupRolesNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetGroupRolesNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetGroupRolesInternalServerError creates a GetGroupRolesInternalServerError with default headers values
func NewGetGroupRolesInternalServerError() *GetGroupRolesInternalServerError {
	return &GetGroupRolesInternalServerError{}
}

/*
GetGroupRolesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetGroupRolesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get group roles internal server error response has a 2xx status code
func (o *GetGroupRolesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get group roles internal server error response has a 3xx status code
func (o *GetGroupRolesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get group roles internal server error response has a 4xx status code
func (o *GetGroupRolesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get group roles internal server error response has a 5xx status code
func (o *GetGroupRolesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get group roles internal server error response a status code equal to that given
func (o *GetGroupRolesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get group roles internal server error response
func (o *GetGroupRolesInternalServerError) Code() int {
	return 500
}

func (o *GetGroupRolesInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups/{group_id}/roles][%d] getGroupRolesInternalServerError %s", 500, payload)
}

func (o *GetGroupRolesInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /groupsync/groups/{group_id}/roles][%d] getGroupRolesInternalServerError %s", 500, payload)
}

func (o *GetGroupRolesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetGroupRolesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
