// Code generated by go-swagger; DO NOT EDIT.

package health

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetHealthReader is a Reader for the GetHealth structure.
type GetHealthReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetHealthReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetHealthOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 503:
		result := NewGetHealthServiceUnavailable()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /health] getHealth", response, response.Code())
	}
}

// NewGetHealthOK creates a GetHealthOK with default headers values
func NewGetHealthOK() *GetHealthOK {
	return &GetHealthOK{}
}

/*
GetHealthOK describes a response with status code 200, with default header values.

healthResponse
*/
type GetHealthOK struct {
	Payload *models.HealthResponse
}

// IsSuccess returns true when this get health Ok response has a 2xx status code
func (o *GetHealthOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get health Ok response has a 3xx status code
func (o *GetHealthOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get health Ok response has a 4xx status code
func (o *GetHealthOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get health Ok response has a 5xx status code
func (o *GetHealthOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get health Ok response a status code equal to that given
func (o *GetHealthOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get health Ok response
func (o *GetHealthOK) Code() int {
	return 200
}

func (o *GetHealthOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /health][%d] getHealthOk %s", 200, payload)
}

func (o *GetHealthOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /health][%d] getHealthOk %s", 200, payload)
}

func (o *GetHealthOK) GetPayload() *models.HealthResponse {
	return o.Payload
}

func (o *GetHealthOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HealthResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetHealthServiceUnavailable creates a GetHealthServiceUnavailable with default headers values
func NewGetHealthServiceUnavailable() *GetHealthServiceUnavailable {
	return &GetHealthServiceUnavailable{}
}

/*
GetHealthServiceUnavailable describes a response with status code 503, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetHealthServiceUnavailable struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get health service unavailable response has a 2xx status code
func (o *GetHealthServiceUnavailable) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get health service unavailable response has a 3xx status code
func (o *GetHealthServiceUnavailable) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get health service unavailable response has a 4xx status code
func (o *GetHealthServiceUnavailable) IsClientError() bool {
	return false
}

// IsServerError returns true when this get health service unavailable response has a 5xx status code
func (o *GetHealthServiceUnavailable) IsServerError() bool {
	return true
}

// IsCode returns true when this get health service unavailable response a status code equal to that given
func (o *GetHealthServiceUnavailable) IsCode(code int) bool {
	return code == 503
}

// Code gets the status code for the get health service unavailable response
func (o *GetHealthServiceUnavailable) Code() int {
	return 503
}

func (o *GetHealthServiceUnavailable) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /health][%d] getHealthServiceUnavailable %s", 503, payload)
}

func (o *GetHealthServiceUnavailable) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /health][%d] getHealthServiceUnavailable %s", 503, payload)
}

func (o *GetHealthServiceUnavailable) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetHealthServiceUnavailable) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
