// Code generated by go-swagger; DO NOT EDIT.

package migrations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreateSnapshotReader is a Reader for the CreateSnapshot structure.
type CreateSnapshotReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateSnapshotReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateSnapshotOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewCreateSnapshotBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewCreateSnapshotUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateSnapshotForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateSnapshotInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /cloudmigration/migration/{uid}/snapshot] createSnapshot", response, response.Code())
	}
}

// NewCreateSnapshotOK creates a CreateSnapshotOK with default headers values
func NewCreateSnapshotOK() *CreateSnapshotOK {
	return &CreateSnapshotOK{}
}

/*
CreateSnapshotOK describes a response with status code 200, with default header values.

(empty)
*/
type CreateSnapshotOK struct {
	Payload *models.CreateSnapshotResponseDTO
}

// IsSuccess returns true when this create snapshot Ok response has a 2xx status code
func (o *CreateSnapshotOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create snapshot Ok response has a 3xx status code
func (o *CreateSnapshotOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create snapshot Ok response has a 4xx status code
func (o *CreateSnapshotOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create snapshot Ok response has a 5xx status code
func (o *CreateSnapshotOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create snapshot Ok response a status code equal to that given
func (o *CreateSnapshotOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create snapshot Ok response
func (o *CreateSnapshotOK) Code() int {
	return 200
}

func (o *CreateSnapshotOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot][%d] createSnapshotOk %s", 200, payload)
}

func (o *CreateSnapshotOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot][%d] createSnapshotOk %s", 200, payload)
}

func (o *CreateSnapshotOK) GetPayload() *models.CreateSnapshotResponseDTO {
	return o.Payload
}

func (o *CreateSnapshotOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CreateSnapshotResponseDTO)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateSnapshotBadRequest creates a CreateSnapshotBadRequest with default headers values
func NewCreateSnapshotBadRequest() *CreateSnapshotBadRequest {
	return &CreateSnapshotBadRequest{}
}

/*
CreateSnapshotBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type CreateSnapshotBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create snapshot bad request response has a 2xx status code
func (o *CreateSnapshotBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create snapshot bad request response has a 3xx status code
func (o *CreateSnapshotBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create snapshot bad request response has a 4xx status code
func (o *CreateSnapshotBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this create snapshot bad request response has a 5xx status code
func (o *CreateSnapshotBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this create snapshot bad request response a status code equal to that given
func (o *CreateSnapshotBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the create snapshot bad request response
func (o *CreateSnapshotBadRequest) Code() int {
	return 400
}

func (o *CreateSnapshotBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot][%d] createSnapshotBadRequest %s", 400, payload)
}

func (o *CreateSnapshotBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot][%d] createSnapshotBadRequest %s", 400, payload)
}

func (o *CreateSnapshotBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateSnapshotBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateSnapshotUnauthorized creates a CreateSnapshotUnauthorized with default headers values
func NewCreateSnapshotUnauthorized() *CreateSnapshotUnauthorized {
	return &CreateSnapshotUnauthorized{}
}

/*
CreateSnapshotUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type CreateSnapshotUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create snapshot unauthorized response has a 2xx status code
func (o *CreateSnapshotUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create snapshot unauthorized response has a 3xx status code
func (o *CreateSnapshotUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create snapshot unauthorized response has a 4xx status code
func (o *CreateSnapshotUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create snapshot unauthorized response has a 5xx status code
func (o *CreateSnapshotUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create snapshot unauthorized response a status code equal to that given
func (o *CreateSnapshotUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create snapshot unauthorized response
func (o *CreateSnapshotUnauthorized) Code() int {
	return 401
}

func (o *CreateSnapshotUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot][%d] createSnapshotUnauthorized %s", 401, payload)
}

func (o *CreateSnapshotUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot][%d] createSnapshotUnauthorized %s", 401, payload)
}

func (o *CreateSnapshotUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateSnapshotUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateSnapshotForbidden creates a CreateSnapshotForbidden with default headers values
func NewCreateSnapshotForbidden() *CreateSnapshotForbidden {
	return &CreateSnapshotForbidden{}
}

/*
CreateSnapshotForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CreateSnapshotForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create snapshot forbidden response has a 2xx status code
func (o *CreateSnapshotForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create snapshot forbidden response has a 3xx status code
func (o *CreateSnapshotForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create snapshot forbidden response has a 4xx status code
func (o *CreateSnapshotForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create snapshot forbidden response has a 5xx status code
func (o *CreateSnapshotForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create snapshot forbidden response a status code equal to that given
func (o *CreateSnapshotForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create snapshot forbidden response
func (o *CreateSnapshotForbidden) Code() int {
	return 403
}

func (o *CreateSnapshotForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot][%d] createSnapshotForbidden %s", 403, payload)
}

func (o *CreateSnapshotForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot][%d] createSnapshotForbidden %s", 403, payload)
}

func (o *CreateSnapshotForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateSnapshotForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateSnapshotInternalServerError creates a CreateSnapshotInternalServerError with default headers values
func NewCreateSnapshotInternalServerError() *CreateSnapshotInternalServerError {
	return &CreateSnapshotInternalServerError{}
}

/*
CreateSnapshotInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CreateSnapshotInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create snapshot internal server error response has a 2xx status code
func (o *CreateSnapshotInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create snapshot internal server error response has a 3xx status code
func (o *CreateSnapshotInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create snapshot internal server error response has a 4xx status code
func (o *CreateSnapshotInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create snapshot internal server error response has a 5xx status code
func (o *CreateSnapshotInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create snapshot internal server error response a status code equal to that given
func (o *CreateSnapshotInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create snapshot internal server error response
func (o *CreateSnapshotInternalServerError) Code() int {
	return 500
}

func (o *CreateSnapshotInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot][%d] createSnapshotInternalServerError %s", 500, payload)
}

func (o *CreateSnapshotInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /cloudmigration/migration/{uid}/snapshot][%d] createSnapshotInternalServerError %s", 500, payload)
}

func (o *CreateSnapshotInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateSnapshotInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
