// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetOrgByIDReader is a Reader for the GetOrgByID structure.
type GetOrgByIDReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetOrgByIDReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetOrgByIDOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewGetOrgByIDUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetOrgByIDForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetOrgByIDInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /orgs/{org_id}] getOrgByID", response, response.Code())
	}
}

// NewGetOrgByIDOK creates a GetOrgByIDOK with default headers values
func NewGetOrgByIDOK() *GetOrgByIDOK {
	return &GetOrgByIDOK{}
}

/*
GetOrgByIDOK describes a response with status code 200, with default header values.

(empty)
*/
type GetOrgByIDOK struct {
	Payload *models.OrgDetailsDTO
}

// IsSuccess returns true when this get org by Id Ok response has a 2xx status code
func (o *GetOrgByIDOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get org by Id Ok response has a 3xx status code
func (o *GetOrgByIDOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get org by Id Ok response has a 4xx status code
func (o *GetOrgByIDOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get org by Id Ok response has a 5xx status code
func (o *GetOrgByIDOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get org by Id Ok response a status code equal to that given
func (o *GetOrgByIDOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get org by Id Ok response
func (o *GetOrgByIDOK) Code() int {
	return 200
}

func (o *GetOrgByIDOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /orgs/{org_id}][%d] getOrgByIdOk %s", 200, payload)
}

func (o *GetOrgByIDOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /orgs/{org_id}][%d] getOrgByIdOk %s", 200, payload)
}

func (o *GetOrgByIDOK) GetPayload() *models.OrgDetailsDTO {
	return o.Payload
}

func (o *GetOrgByIDOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.OrgDetailsDTO)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetOrgByIDUnauthorized creates a GetOrgByIDUnauthorized with default headers values
func NewGetOrgByIDUnauthorized() *GetOrgByIDUnauthorized {
	return &GetOrgByIDUnauthorized{}
}

/*
GetOrgByIDUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetOrgByIDUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get org by Id unauthorized response has a 2xx status code
func (o *GetOrgByIDUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get org by Id unauthorized response has a 3xx status code
func (o *GetOrgByIDUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get org by Id unauthorized response has a 4xx status code
func (o *GetOrgByIDUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get org by Id unauthorized response has a 5xx status code
func (o *GetOrgByIDUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get org by Id unauthorized response a status code equal to that given
func (o *GetOrgByIDUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get org by Id unauthorized response
func (o *GetOrgByIDUnauthorized) Code() int {
	return 401
}

func (o *GetOrgByIDUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /orgs/{org_id}][%d] getOrgByIdUnauthorized %s", 401, payload)
}

func (o *GetOrgByIDUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /orgs/{org_id}][%d] getOrgByIdUnauthorized %s", 401, payload)
}

func (o *GetOrgByIDUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetOrgByIDUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetOrgByIDForbidden creates a GetOrgByIDForbidden with default headers values
func NewGetOrgByIDForbidden() *GetOrgByIDForbidden {
	return &GetOrgByIDForbidden{}
}

/*
GetOrgByIDForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetOrgByIDForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get org by Id forbidden response has a 2xx status code
func (o *GetOrgByIDForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get org by Id forbidden response has a 3xx status code
func (o *GetOrgByIDForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get org by Id forbidden response has a 4xx status code
func (o *GetOrgByIDForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get org by Id forbidden response has a 5xx status code
func (o *GetOrgByIDForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get org by Id forbidden response a status code equal to that given
func (o *GetOrgByIDForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get org by Id forbidden response
func (o *GetOrgByIDForbidden) Code() int {
	return 403
}

func (o *GetOrgByIDForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /orgs/{org_id}][%d] getOrgByIdForbidden %s", 403, payload)
}

func (o *GetOrgByIDForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /orgs/{org_id}][%d] getOrgByIdForbidden %s", 403, payload)
}

func (o *GetOrgByIDForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetOrgByIDForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetOrgByIDInternalServerError creates a GetOrgByIDInternalServerError with default headers values
func NewGetOrgByIDInternalServerError() *GetOrgByIDInternalServerError {
	return &GetOrgByIDInternalServerError{}
}

/*
GetOrgByIDInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetOrgByIDInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get org by Id internal server error response has a 2xx status code
func (o *GetOrgByIDInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get org by Id internal server error response has a 3xx status code
func (o *GetOrgByIDInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get org by Id internal server error response has a 4xx status code
func (o *GetOrgByIDInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get org by Id internal server error response has a 5xx status code
func (o *GetOrgByIDInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get org by Id internal server error response a status code equal to that given
func (o *GetOrgByIDInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get org by Id internal server error response
func (o *GetOrgByIDInternalServerError) Code() int {
	return 500
}

func (o *GetOrgByIDInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /orgs/{org_id}][%d] getOrgByIdInternalServerError %s", 500, payload)
}

func (o *GetOrgByIDInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /orgs/{org_id}][%d] getOrgByIdInternalServerError %s", 500, payload)
}

func (o *GetOrgByIDInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetOrgByIDInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
