// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateOrgReader is a Reader for the UpdateOrg structure.
type UpdateOrgReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateOrgReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateOrgOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateOrgBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUpdateOrgUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateOrgForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateOrgInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /orgs/{org_id}] updateOrg", response, response.Code())
	}
}

// NewUpdateOrgOK creates a UpdateOrgOK with default headers values
func NewUpdateOrgOK() *UpdateOrgOK {
	return &UpdateOrgOK{}
}

/*
UpdateOrgOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type UpdateOrgOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this update org Ok response has a 2xx status code
func (o *UpdateOrgOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update org Ok response has a 3xx status code
func (o *UpdateOrgOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org Ok response has a 4xx status code
func (o *UpdateOrgOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update org Ok response has a 5xx status code
func (o *UpdateOrgOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update org Ok response a status code equal to that given
func (o *UpdateOrgOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update org Ok response
func (o *UpdateOrgOK) Code() int {
	return 200
}

func (o *UpdateOrgOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}][%d] updateOrgOk %s", 200, payload)
}

func (o *UpdateOrgOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}][%d] updateOrgOk %s", 200, payload)
}

func (o *UpdateOrgOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *UpdateOrgOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateOrgBadRequest creates a UpdateOrgBadRequest with default headers values
func NewUpdateOrgBadRequest() *UpdateOrgBadRequest {
	return &UpdateOrgBadRequest{}
}

/*
UpdateOrgBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type UpdateOrgBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update org bad request response has a 2xx status code
func (o *UpdateOrgBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update org bad request response has a 3xx status code
func (o *UpdateOrgBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org bad request response has a 4xx status code
func (o *UpdateOrgBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update org bad request response has a 5xx status code
func (o *UpdateOrgBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update org bad request response a status code equal to that given
func (o *UpdateOrgBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update org bad request response
func (o *UpdateOrgBadRequest) Code() int {
	return 400
}

func (o *UpdateOrgBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}][%d] updateOrgBadRequest %s", 400, payload)
}

func (o *UpdateOrgBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}][%d] updateOrgBadRequest %s", 400, payload)
}

func (o *UpdateOrgBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateOrgBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateOrgUnauthorized creates a UpdateOrgUnauthorized with default headers values
func NewUpdateOrgUnauthorized() *UpdateOrgUnauthorized {
	return &UpdateOrgUnauthorized{}
}

/*
UpdateOrgUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateOrgUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update org unauthorized response has a 2xx status code
func (o *UpdateOrgUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update org unauthorized response has a 3xx status code
func (o *UpdateOrgUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org unauthorized response has a 4xx status code
func (o *UpdateOrgUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update org unauthorized response has a 5xx status code
func (o *UpdateOrgUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update org unauthorized response a status code equal to that given
func (o *UpdateOrgUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update org unauthorized response
func (o *UpdateOrgUnauthorized) Code() int {
	return 401
}

func (o *UpdateOrgUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}][%d] updateOrgUnauthorized %s", 401, payload)
}

func (o *UpdateOrgUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}][%d] updateOrgUnauthorized %s", 401, payload)
}

func (o *UpdateOrgUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateOrgUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateOrgForbidden creates a UpdateOrgForbidden with default headers values
func NewUpdateOrgForbidden() *UpdateOrgForbidden {
	return &UpdateOrgForbidden{}
}

/*
UpdateOrgForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateOrgForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update org forbidden response has a 2xx status code
func (o *UpdateOrgForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update org forbidden response has a 3xx status code
func (o *UpdateOrgForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org forbidden response has a 4xx status code
func (o *UpdateOrgForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update org forbidden response has a 5xx status code
func (o *UpdateOrgForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update org forbidden response a status code equal to that given
func (o *UpdateOrgForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update org forbidden response
func (o *UpdateOrgForbidden) Code() int {
	return 403
}

func (o *UpdateOrgForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}][%d] updateOrgForbidden %s", 403, payload)
}

func (o *UpdateOrgForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}][%d] updateOrgForbidden %s", 403, payload)
}

func (o *UpdateOrgForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateOrgForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateOrgInternalServerError creates a UpdateOrgInternalServerError with default headers values
func NewUpdateOrgInternalServerError() *UpdateOrgInternalServerError {
	return &UpdateOrgInternalServerError{}
}

/*
UpdateOrgInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateOrgInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update org internal server error response has a 2xx status code
func (o *UpdateOrgInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update org internal server error response has a 3xx status code
func (o *UpdateOrgInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update org internal server error response has a 4xx status code
func (o *UpdateOrgInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update org internal server error response has a 5xx status code
func (o *UpdateOrgInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update org internal server error response a status code equal to that given
func (o *UpdateOrgInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update org internal server error response
func (o *UpdateOrgInternalServerError) Code() int {
	return 500
}

func (o *UpdateOrgInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}][%d] updateOrgInternalServerError %s", 500, payload)
}

func (o *UpdateOrgInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /orgs/{org_id}][%d] updateOrgInternalServerError %s", 500, payload)
}

func (o *UpdateOrgInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateOrgInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
