// Code generated by go-swagger; DO NOT EDIT.

package playlists

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// SearchPlaylistsReader is a Reader for the SearchPlaylists structure.
type SearchPlaylistsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SearchPlaylistsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSearchPlaylistsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 500:
		result := NewSearchPlaylistsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /playlists] searchPlaylists", response, response.Code())
	}
}

// NewSearchPlaylistsOK creates a SearchPlaylistsOK with default headers values
func NewSearchPlaylistsOK() *SearchPlaylistsOK {
	return &SearchPlaylistsOK{}
}

/*
SearchPlaylistsOK describes a response with status code 200, with default header values.

(empty)
*/
type SearchPlaylistsOK struct {
	Payload models.Playlists
}

// IsSuccess returns true when this search playlists Ok response has a 2xx status code
func (o *SearchPlaylistsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this search playlists Ok response has a 3xx status code
func (o *SearchPlaylistsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search playlists Ok response has a 4xx status code
func (o *SearchPlaylistsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this search playlists Ok response has a 5xx status code
func (o *SearchPlaylistsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this search playlists Ok response a status code equal to that given
func (o *SearchPlaylistsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the search playlists Ok response
func (o *SearchPlaylistsOK) Code() int {
	return 200
}

func (o *SearchPlaylistsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists][%d] searchPlaylistsOk %s", 200, payload)
}

func (o *SearchPlaylistsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists][%d] searchPlaylistsOk %s", 200, payload)
}

func (o *SearchPlaylistsOK) GetPayload() models.Playlists {
	return o.Payload
}

func (o *SearchPlaylistsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSearchPlaylistsInternalServerError creates a SearchPlaylistsInternalServerError with default headers values
func NewSearchPlaylistsInternalServerError() *SearchPlaylistsInternalServerError {
	return &SearchPlaylistsInternalServerError{}
}

/*
SearchPlaylistsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type SearchPlaylistsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this search playlists internal server error response has a 2xx status code
func (o *SearchPlaylistsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this search playlists internal server error response has a 3xx status code
func (o *SearchPlaylistsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this search playlists internal server error response has a 4xx status code
func (o *SearchPlaylistsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this search playlists internal server error response has a 5xx status code
func (o *SearchPlaylistsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this search playlists internal server error response a status code equal to that given
func (o *SearchPlaylistsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the search playlists internal server error response
func (o *SearchPlaylistsInternalServerError) Code() int {
	return 500
}

func (o *SearchPlaylistsInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists][%d] searchPlaylistsInternalServerError %s", 500, payload)
}

func (o *SearchPlaylistsInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /playlists][%d] searchPlaylistsInternalServerError %s", 500, payload)
}

func (o *SearchPlaylistsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *SearchPlaylistsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
