// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGetAlertRuleExportParams creates a new GetAlertRuleExportParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetAlertRuleExportParams() *GetAlertRuleExportParams {
	return &GetAlertRuleExportParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetAlertRuleExportParamsWithTimeout creates a new GetAlertRuleExportParams object
// with the ability to set a timeout on a request.
func NewGetAlertRuleExportParamsWithTimeout(timeout time.Duration) *GetAlertRuleExportParams {
	return &GetAlertRuleExportParams{
		timeout: timeout,
	}
}

// NewGetAlertRuleExportParamsWithContext creates a new GetAlertRuleExportParams object
// with the ability to set a context for a request.
func NewGetAlertRuleExportParamsWithContext(ctx context.Context) *GetAlertRuleExportParams {
	return &GetAlertRuleExportParams{
		Context: ctx,
	}
}

// NewGetAlertRuleExportParamsWithHTTPClient creates a new GetAlertRuleExportParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetAlertRuleExportParamsWithHTTPClient(client *http.Client) *GetAlertRuleExportParams {
	return &GetAlertRuleExportParams{
		HTTPClient: client,
	}
}

/*
GetAlertRuleExportParams contains all the parameters to send to the API endpoint

	for the get alert rule export operation.

	Typically these are written to a http.Request.
*/
type GetAlertRuleExportParams struct {

	/* UID.

	   Alert rule UID
	*/
	UID string

	/* Download.

	   Whether to initiate a download of the file or not.
	*/
	Download *bool

	/* Format.

	   Format of the downloaded file. Supported yaml, json or hcl. Accept header can also be used, but the query parameter will take precedence.

	   Default: "yaml"
	*/
	Format *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get alert rule export params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAlertRuleExportParams) WithDefaults() *GetAlertRuleExportParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get alert rule export params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetAlertRuleExportParams) SetDefaults() {
	var (
		downloadDefault = bool(false)

		formatDefault = string("yaml")
	)

	val := GetAlertRuleExportParams{
		Download: &downloadDefault,
		Format:   &formatDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the get alert rule export params
func (o *GetAlertRuleExportParams) WithTimeout(timeout time.Duration) *GetAlertRuleExportParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get alert rule export params
func (o *GetAlertRuleExportParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get alert rule export params
func (o *GetAlertRuleExportParams) WithContext(ctx context.Context) *GetAlertRuleExportParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get alert rule export params
func (o *GetAlertRuleExportParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get alert rule export params
func (o *GetAlertRuleExportParams) WithHTTPClient(client *http.Client) *GetAlertRuleExportParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get alert rule export params
func (o *GetAlertRuleExportParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithUID adds the uid to the get alert rule export params
func (o *GetAlertRuleExportParams) WithUID(uid string) *GetAlertRuleExportParams {
	o.SetUID(uid)
	return o
}

// SetUID adds the uid to the get alert rule export params
func (o *GetAlertRuleExportParams) SetUID(uid string) {
	o.UID = uid
}

// WithDownload adds the download to the get alert rule export params
func (o *GetAlertRuleExportParams) WithDownload(download *bool) *GetAlertRuleExportParams {
	o.SetDownload(download)
	return o
}

// SetDownload adds the download to the get alert rule export params
func (o *GetAlertRuleExportParams) SetDownload(download *bool) {
	o.Download = download
}

// WithFormat adds the format to the get alert rule export params
func (o *GetAlertRuleExportParams) WithFormat(format *string) *GetAlertRuleExportParams {
	o.SetFormat(format)
	return o
}

// SetFormat adds the format to the get alert rule export params
func (o *GetAlertRuleExportParams) SetFormat(format *string) {
	o.Format = format
}

// WriteToRequest writes these params to a swagger request
func (o *GetAlertRuleExportParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param UID
	if err := r.SetPathParam("UID", o.UID); err != nil {
		return err
	}

	if o.Download != nil {

		// query param download
		var qrDownload bool

		if o.Download != nil {
			qrDownload = *o.Download
		}
		qDownload := swag.FormatBool(qrDownload)
		if qDownload != "" {

			if err := r.SetQueryParam("download", qDownload); err != nil {
				return err
			}
		}
	}

	if o.Format != nil {

		// query param format
		var qrFormat string

		if o.Format != nil {
			qrFormat = *o.Format
		}
		qFormat := qrFormat
		if qFormat != "" {

			if err := r.SetQueryParam("format", qFormat); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
