// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewPostAlertRuleParams creates a new PostAlertRuleParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPostAlertRuleParams() *PostAlertRuleParams {
	return &PostAlertRuleParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPostAlertRuleParamsWithTimeout creates a new PostAlertRuleParams object
// with the ability to set a timeout on a request.
func NewPostAlertRuleParamsWithTimeout(timeout time.Duration) *PostAlertRuleParams {
	return &PostAlertRuleParams{
		timeout: timeout,
	}
}

// NewPostAlertRuleParamsWithContext creates a new PostAlertRuleParams object
// with the ability to set a context for a request.
func NewPostAlertRuleParamsWithContext(ctx context.Context) *PostAlertRuleParams {
	return &PostAlertRuleParams{
		Context: ctx,
	}
}

// NewPostAlertRuleParamsWithHTTPClient creates a new PostAlertRuleParams object
// with the ability to set a custom HTTPClient for a request.
func NewPostAlertRuleParamsWithHTTPClient(client *http.Client) *PostAlertRuleParams {
	return &PostAlertRuleParams{
		HTTPClient: client,
	}
}

/*
PostAlertRuleParams contains all the parameters to send to the API endpoint

	for the post alert rule operation.

	Typically these are written to a http.Request.
*/
type PostAlertRuleParams struct {

	// Body.
	Body *models.ProvisionedAlertRule

	// XDisableProvenance.
	XDisableProvenance *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the post alert rule params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PostAlertRuleParams) WithDefaults() *PostAlertRuleParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the post alert rule params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PostAlertRuleParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the post alert rule params
func (o *PostAlertRuleParams) WithTimeout(timeout time.Duration) *PostAlertRuleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the post alert rule params
func (o *PostAlertRuleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the post alert rule params
func (o *PostAlertRuleParams) WithContext(ctx context.Context) *PostAlertRuleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the post alert rule params
func (o *PostAlertRuleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the post alert rule params
func (o *PostAlertRuleParams) WithHTTPClient(client *http.Client) *PostAlertRuleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the post alert rule params
func (o *PostAlertRuleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the post alert rule params
func (o *PostAlertRuleParams) WithBody(body *models.ProvisionedAlertRule) *PostAlertRuleParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the post alert rule params
func (o *PostAlertRuleParams) SetBody(body *models.ProvisionedAlertRule) {
	o.Body = body
}

// WithXDisableProvenance adds the xDisableProvenance to the post alert rule params
func (o *PostAlertRuleParams) WithXDisableProvenance(xDisableProvenance *string) *PostAlertRuleParams {
	o.SetXDisableProvenance(xDisableProvenance)
	return o
}

// SetXDisableProvenance adds the xDisableProvenance to the post alert rule params
func (o *PostAlertRuleParams) SetXDisableProvenance(xDisableProvenance *string) {
	o.XDisableProvenance = xDisableProvenance
}

// WriteToRequest writes these params to a swagger request
func (o *PostAlertRuleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.XDisableProvenance != nil {

		// header param X-Disable-Provenance
		if err := r.SetHeaderParam("X-Disable-Provenance", *o.XDisableProvenance); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
