// Code generated by go-swagger; DO NOT EDIT.

package reports

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateReportReader is a Reader for the UpdateReport structure.
type UpdateReportReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateReportReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateReportOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateReportBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUpdateReportUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateReportForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdateReportNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateReportInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /reports/{id}] updateReport", response, response.Code())
	}
}

// NewUpdateReportOK creates a UpdateReportOK with default headers values
func NewUpdateReportOK() *UpdateReportOK {
	return &UpdateReportOK{}
}

/*
UpdateReportOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type UpdateReportOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this update report Ok response has a 2xx status code
func (o *UpdateReportOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update report Ok response has a 3xx status code
func (o *UpdateReportOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update report Ok response has a 4xx status code
func (o *UpdateReportOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update report Ok response has a 5xx status code
func (o *UpdateReportOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update report Ok response a status code equal to that given
func (o *UpdateReportOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update report Ok response
func (o *UpdateReportOK) Code() int {
	return 200
}

func (o *UpdateReportOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /reports/{id}][%d] updateReportOk %s", 200, payload)
}

func (o *UpdateReportOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /reports/{id}][%d] updateReportOk %s", 200, payload)
}

func (o *UpdateReportOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *UpdateReportOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateReportBadRequest creates a UpdateReportBadRequest with default headers values
func NewUpdateReportBadRequest() *UpdateReportBadRequest {
	return &UpdateReportBadRequest{}
}

/*
UpdateReportBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type UpdateReportBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update report bad request response has a 2xx status code
func (o *UpdateReportBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update report bad request response has a 3xx status code
func (o *UpdateReportBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update report bad request response has a 4xx status code
func (o *UpdateReportBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update report bad request response has a 5xx status code
func (o *UpdateReportBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update report bad request response a status code equal to that given
func (o *UpdateReportBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update report bad request response
func (o *UpdateReportBadRequest) Code() int {
	return 400
}

func (o *UpdateReportBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /reports/{id}][%d] updateReportBadRequest %s", 400, payload)
}

func (o *UpdateReportBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /reports/{id}][%d] updateReportBadRequest %s", 400, payload)
}

func (o *UpdateReportBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateReportBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateReportUnauthorized creates a UpdateReportUnauthorized with default headers values
func NewUpdateReportUnauthorized() *UpdateReportUnauthorized {
	return &UpdateReportUnauthorized{}
}

/*
UpdateReportUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateReportUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update report unauthorized response has a 2xx status code
func (o *UpdateReportUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update report unauthorized response has a 3xx status code
func (o *UpdateReportUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update report unauthorized response has a 4xx status code
func (o *UpdateReportUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update report unauthorized response has a 5xx status code
func (o *UpdateReportUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update report unauthorized response a status code equal to that given
func (o *UpdateReportUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update report unauthorized response
func (o *UpdateReportUnauthorized) Code() int {
	return 401
}

func (o *UpdateReportUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /reports/{id}][%d] updateReportUnauthorized %s", 401, payload)
}

func (o *UpdateReportUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /reports/{id}][%d] updateReportUnauthorized %s", 401, payload)
}

func (o *UpdateReportUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateReportUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateReportForbidden creates a UpdateReportForbidden with default headers values
func NewUpdateReportForbidden() *UpdateReportForbidden {
	return &UpdateReportForbidden{}
}

/*
UpdateReportForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateReportForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update report forbidden response has a 2xx status code
func (o *UpdateReportForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update report forbidden response has a 3xx status code
func (o *UpdateReportForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update report forbidden response has a 4xx status code
func (o *UpdateReportForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update report forbidden response has a 5xx status code
func (o *UpdateReportForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update report forbidden response a status code equal to that given
func (o *UpdateReportForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update report forbidden response
func (o *UpdateReportForbidden) Code() int {
	return 403
}

func (o *UpdateReportForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /reports/{id}][%d] updateReportForbidden %s", 403, payload)
}

func (o *UpdateReportForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /reports/{id}][%d] updateReportForbidden %s", 403, payload)
}

func (o *UpdateReportForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateReportForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateReportNotFound creates a UpdateReportNotFound with default headers values
func NewUpdateReportNotFound() *UpdateReportNotFound {
	return &UpdateReportNotFound{}
}

/*
UpdateReportNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type UpdateReportNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update report not found response has a 2xx status code
func (o *UpdateReportNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update report not found response has a 3xx status code
func (o *UpdateReportNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update report not found response has a 4xx status code
func (o *UpdateReportNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update report not found response has a 5xx status code
func (o *UpdateReportNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update report not found response a status code equal to that given
func (o *UpdateReportNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update report not found response
func (o *UpdateReportNotFound) Code() int {
	return 404
}

func (o *UpdateReportNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /reports/{id}][%d] updateReportNotFound %s", 404, payload)
}

func (o *UpdateReportNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /reports/{id}][%d] updateReportNotFound %s", 404, payload)
}

func (o *UpdateReportNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateReportNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateReportInternalServerError creates a UpdateReportInternalServerError with default headers values
func NewUpdateReportInternalServerError() *UpdateReportInternalServerError {
	return &UpdateReportInternalServerError{}
}

/*
UpdateReportInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateReportInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update report internal server error response has a 2xx status code
func (o *UpdateReportInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update report internal server error response has a 3xx status code
func (o *UpdateReportInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update report internal server error response has a 4xx status code
func (o *UpdateReportInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update report internal server error response has a 5xx status code
func (o *UpdateReportInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update report internal server error response a status code equal to that given
func (o *UpdateReportInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update report internal server error response
func (o *UpdateReportInternalServerError) Code() int {
	return 500
}

func (o *UpdateReportInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /reports/{id}][%d] updateReportInternalServerError %s", 500, payload)
}

func (o *UpdateReportInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /reports/{id}][%d] updateReportInternalServerError %s", 500, payload)
}

func (o *UpdateReportInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateReportInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
