// Code generated by go-swagger; DO NOT EDIT.

package sso_settings

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// ListAllProvidersSettingsReader is a Reader for the ListAllProvidersSettings structure.
type ListAllProvidersSettingsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListAllProvidersSettingsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListAllProvidersSettingsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewListAllProvidersSettingsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewListAllProvidersSettingsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewListAllProvidersSettingsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /v1/sso-settings] listAllProvidersSettings", response, response.Code())
	}
}

// NewListAllProvidersSettingsOK creates a ListAllProvidersSettingsOK with default headers values
func NewListAllProvidersSettingsOK() *ListAllProvidersSettingsOK {
	return &ListAllProvidersSettingsOK{}
}

/*
ListAllProvidersSettingsOK describes a response with status code 200, with default header values.

(empty)
*/
type ListAllProvidersSettingsOK struct {
	Payload []*models.ListAllProvidersSettingsOKBodyItems
}

// IsSuccess returns true when this list all providers settings Ok response has a 2xx status code
func (o *ListAllProvidersSettingsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list all providers settings Ok response has a 3xx status code
func (o *ListAllProvidersSettingsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list all providers settings Ok response has a 4xx status code
func (o *ListAllProvidersSettingsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list all providers settings Ok response has a 5xx status code
func (o *ListAllProvidersSettingsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list all providers settings Ok response a status code equal to that given
func (o *ListAllProvidersSettingsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list all providers settings Ok response
func (o *ListAllProvidersSettingsOK) Code() int {
	return 200
}

func (o *ListAllProvidersSettingsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings][%d] listAllProvidersSettingsOk %s", 200, payload)
}

func (o *ListAllProvidersSettingsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings][%d] listAllProvidersSettingsOk %s", 200, payload)
}

func (o *ListAllProvidersSettingsOK) GetPayload() []*models.ListAllProvidersSettingsOKBodyItems {
	return o.Payload
}

func (o *ListAllProvidersSettingsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListAllProvidersSettingsBadRequest creates a ListAllProvidersSettingsBadRequest with default headers values
func NewListAllProvidersSettingsBadRequest() *ListAllProvidersSettingsBadRequest {
	return &ListAllProvidersSettingsBadRequest{}
}

/*
ListAllProvidersSettingsBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type ListAllProvidersSettingsBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list all providers settings bad request response has a 2xx status code
func (o *ListAllProvidersSettingsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list all providers settings bad request response has a 3xx status code
func (o *ListAllProvidersSettingsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list all providers settings bad request response has a 4xx status code
func (o *ListAllProvidersSettingsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this list all providers settings bad request response has a 5xx status code
func (o *ListAllProvidersSettingsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this list all providers settings bad request response a status code equal to that given
func (o *ListAllProvidersSettingsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the list all providers settings bad request response
func (o *ListAllProvidersSettingsBadRequest) Code() int {
	return 400
}

func (o *ListAllProvidersSettingsBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings][%d] listAllProvidersSettingsBadRequest %s", 400, payload)
}

func (o *ListAllProvidersSettingsBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings][%d] listAllProvidersSettingsBadRequest %s", 400, payload)
}

func (o *ListAllProvidersSettingsBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListAllProvidersSettingsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListAllProvidersSettingsUnauthorized creates a ListAllProvidersSettingsUnauthorized with default headers values
func NewListAllProvidersSettingsUnauthorized() *ListAllProvidersSettingsUnauthorized {
	return &ListAllProvidersSettingsUnauthorized{}
}

/*
ListAllProvidersSettingsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type ListAllProvidersSettingsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list all providers settings unauthorized response has a 2xx status code
func (o *ListAllProvidersSettingsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list all providers settings unauthorized response has a 3xx status code
func (o *ListAllProvidersSettingsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list all providers settings unauthorized response has a 4xx status code
func (o *ListAllProvidersSettingsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this list all providers settings unauthorized response has a 5xx status code
func (o *ListAllProvidersSettingsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this list all providers settings unauthorized response a status code equal to that given
func (o *ListAllProvidersSettingsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the list all providers settings unauthorized response
func (o *ListAllProvidersSettingsUnauthorized) Code() int {
	return 401
}

func (o *ListAllProvidersSettingsUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings][%d] listAllProvidersSettingsUnauthorized %s", 401, payload)
}

func (o *ListAllProvidersSettingsUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings][%d] listAllProvidersSettingsUnauthorized %s", 401, payload)
}

func (o *ListAllProvidersSettingsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListAllProvidersSettingsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListAllProvidersSettingsForbidden creates a ListAllProvidersSettingsForbidden with default headers values
func NewListAllProvidersSettingsForbidden() *ListAllProvidersSettingsForbidden {
	return &ListAllProvidersSettingsForbidden{}
}

/*
ListAllProvidersSettingsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type ListAllProvidersSettingsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list all providers settings forbidden response has a 2xx status code
func (o *ListAllProvidersSettingsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list all providers settings forbidden response has a 3xx status code
func (o *ListAllProvidersSettingsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list all providers settings forbidden response has a 4xx status code
func (o *ListAllProvidersSettingsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this list all providers settings forbidden response has a 5xx status code
func (o *ListAllProvidersSettingsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this list all providers settings forbidden response a status code equal to that given
func (o *ListAllProvidersSettingsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the list all providers settings forbidden response
func (o *ListAllProvidersSettingsForbidden) Code() int {
	return 403
}

func (o *ListAllProvidersSettingsForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings][%d] listAllProvidersSettingsForbidden %s", 403, payload)
}

func (o *ListAllProvidersSettingsForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /v1/sso-settings][%d] listAllProvidersSettingsForbidden %s", 403, payload)
}

func (o *ListAllProvidersSettingsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListAllProvidersSettingsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
