// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// APIKeyDTO Api key DTO
//
// swagger:model ApiKeyDTO
type APIKeyDTO struct {

	// access control
	AccessControl Metadata `json:"accessControl,omitempty"`

	// expiration
	// Format: date-time
	Expiration strfmt.DateTime `json:"expiration,omitempty"`

	// id
	ID int64 `json:"id,omitempty"`

	// last used at
	// Format: date-time
	LastUsedAt strfmt.DateTime `json:"lastUsedAt,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// role
	// Enum: [None Viewer Editor Admin]
	Role string `json:"role,omitempty"`
}

// Validate validates this Api key DTO
func (m *APIKeyDTO) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccessControl(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateExpiration(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLastUsedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APIKeyDTO) validateAccessControl(formats strfmt.Registry) error {
	if swag.IsZero(m.AccessControl) { // not required
		return nil
	}

	if m.AccessControl != nil {
		if err := m.AccessControl.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("accessControl")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("accessControl")
			}
			return err
		}
	}

	return nil
}

func (m *APIKeyDTO) validateExpiration(formats strfmt.Registry) error {
	if swag.IsZero(m.Expiration) { // not required
		return nil
	}

	if err := validate.FormatOf("expiration", "body", "date-time", m.Expiration.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *APIKeyDTO) validateLastUsedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.LastUsedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("lastUsedAt", "body", "date-time", m.LastUsedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

var apiKeyDtoTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["None","Viewer","Editor","Admin"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		apiKeyDtoTypeRolePropEnum = append(apiKeyDtoTypeRolePropEnum, v)
	}
}

const (

	// APIKeyDTORoleNone captures enum value "None"
	APIKeyDTORoleNone string = "None"

	// APIKeyDTORoleViewer captures enum value "Viewer"
	APIKeyDTORoleViewer string = "Viewer"

	// APIKeyDTORoleEditor captures enum value "Editor"
	APIKeyDTORoleEditor string = "Editor"

	// APIKeyDTORoleAdmin captures enum value "Admin"
	APIKeyDTORoleAdmin string = "Admin"
)

// prop value enum
func (m *APIKeyDTO) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, apiKeyDtoTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *APIKeyDTO) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(m.Role) { // not required
		return nil
	}

	// value enum
	if err := m.validateRoleEnum("role", "body", m.Role); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this Api key DTO based on the context it is used
func (m *APIKeyDTO) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccessControl(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *APIKeyDTO) contextValidateAccessControl(ctx context.Context, formats strfmt.Registry) error {

	if swag.IsZero(m.AccessControl) { // not required
		return nil
	}

	if err := m.AccessControl.ContextValidate(ctx, formats); err != nil {
		if ve, ok := err.(*errors.Validation); ok {
			return ve.ValidateName("accessControl")
		} else if ce, ok := err.(*errors.CompositeError); ok {
			return ce.ValidateName("accessControl")
		}
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *APIKeyDTO) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *APIKeyDTO) UnmarshalBinary(b []byte) error {
	var res APIKeyDTO
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
