// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// CreateServiceAccountForm create service account form
//
// swagger:model CreateServiceAccountForm
type CreateServiceAccountForm struct {

	// is disabled
	// Example: false
	IsDisabled bool `json:"isDisabled,omitempty"`

	// name
	// Example: grafana
	Name string `json:"name,omitempty"`

	// role
	// Example: Admin
	// Enum: [None Viewer Editor Admin]
	Role string `json:"role,omitempty"`
}

// Validate validates this create service account form
func (m *CreateServiceAccountForm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var createServiceAccountFormTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["None","Viewer","Editor","Admin"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		createServiceAccountFormTypeRolePropEnum = append(createServiceAccountFormTypeRolePropEnum, v)
	}
}

const (

	// CreateServiceAccountFormRoleNone captures enum value "None"
	CreateServiceAccountFormRoleNone string = "None"

	// CreateServiceAccountFormRoleViewer captures enum value "Viewer"
	CreateServiceAccountFormRoleViewer string = "Viewer"

	// CreateServiceAccountFormRoleEditor captures enum value "Editor"
	CreateServiceAccountFormRoleEditor string = "Editor"

	// CreateServiceAccountFormRoleAdmin captures enum value "Admin"
	CreateServiceAccountFormRoleAdmin string = "Admin"
)

// prop value enum
func (m *CreateServiceAccountForm) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, createServiceAccountFormTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (m *CreateServiceAccountForm) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(m.Role) { // not required
		return nil
	}

	// value enum
	if err := m.validateRoleEnum("role", "body", m.Role); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this create service account form based on context it is used
func (m *CreateServiceAccountForm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *CreateServiceAccountForm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *CreateServiceAccountForm) UnmarshalBinary(b []byte) error {
	var res CreateServiceAccountForm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
