// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Name Name represents an X.509 distinguished name. This only includes the common
// elements of a DN. Note that Name is only an approximation of the X.509
// structure. If an accurate representation is needed, asn1.Unmarshal the raw
// subject or issuer as an [RDNSequence].
//
// swagger:model Name
type Name struct {

	// country
	Country []string `json:"Country"`

	// ExtraNames contains attributes to be copied, raw, into any marshaled
	// distinguished names. Values override any attributes with the same OID.
	// The ExtraNames field is not populated when parsing, see Names.
	ExtraNames []*AttributeTypeAndValue `json:"ExtraNames"`

	// locality
	Locality []string `json:"Locality"`

	// Names contains all parsed attributes. When parsing distinguished names,
	// this can be used to extract non-standard attributes that are not parsed
	// by this package. When marshaling to RDNSequences, the Names field is
	// ignored, see ExtraNames.
	Names []*AttributeTypeAndValue `json:"Names"`

	// serial number
	SerialNumber string `json:"SerialNumber,omitempty"`

	// street address
	StreetAddress []string `json:"StreetAddress"`
}

// Validate validates this name
func (m *Name) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateExtraNames(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNames(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Name) validateExtraNames(formats strfmt.Registry) error {
	if swag.IsZero(m.ExtraNames) { // not required
		return nil
	}

	for i := 0; i < len(m.ExtraNames); i++ {
		if swag.IsZero(m.ExtraNames[i]) { // not required
			continue
		}

		if m.ExtraNames[i] != nil {
			if err := m.ExtraNames[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ExtraNames" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("ExtraNames" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Name) validateNames(formats strfmt.Registry) error {
	if swag.IsZero(m.Names) { // not required
		return nil
	}

	for i := 0; i < len(m.Names); i++ {
		if swag.IsZero(m.Names[i]) { // not required
			continue
		}

		if m.Names[i] != nil {
			if err := m.Names[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Names" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Names" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this name based on the context it is used
func (m *Name) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateExtraNames(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNames(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Name) contextValidateExtraNames(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ExtraNames); i++ {

		if m.ExtraNames[i] != nil {

			if swag.IsZero(m.ExtraNames[i]) { // not required
				return nil
			}

			if err := m.ExtraNames[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("ExtraNames" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("ExtraNames" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Name) contextValidateNames(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Names); i++ {

		if m.Names[i] != nil {

			if swag.IsZero(m.Names[i]) { // not required
				return nil
			}

			if err := m.Names[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("Names" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("Names" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Name) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Name) UnmarshalBinary(b []byte) error {
	var res Name
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
