// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetResourcePermissionsReader is a Reader for the GetResourcePermissions structure.
type GetResourcePermissionsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetResourcePermissionsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetResourcePermissionsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 403:
		result := NewGetResourcePermissionsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewGetResourcePermissionsNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetResourcePermissionsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /access-control/{resource}/{resourceID}] getResourcePermissions", response, response.Code())
	}
}

// NewGetResourcePermissionsOK creates a GetResourcePermissionsOK with default headers values
func NewGetResourcePermissionsOK() *GetResourcePermissionsOK {
	return &GetResourcePermissionsOK{}
}

/*
GetResourcePermissionsOK describes a response with status code 200, with default header values.

(empty)
*/
type GetResourcePermissionsOK struct {
	Payload []*models.ResourcePermissionDTO
}

// IsSuccess returns true when this get resource permissions Ok response has a 2xx status code
func (o *GetResourcePermissionsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get resource permissions Ok response has a 3xx status code
func (o *GetResourcePermissionsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get resource permissions Ok response has a 4xx status code
func (o *GetResourcePermissionsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get resource permissions Ok response has a 5xx status code
func (o *GetResourcePermissionsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get resource permissions Ok response a status code equal to that given
func (o *GetResourcePermissionsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get resource permissions Ok response
func (o *GetResourcePermissionsOK) Code() int {
	return 200
}

func (o *GetResourcePermissionsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/{resourceID}][%d] getResourcePermissionsOk %s", 200, payload)
}

func (o *GetResourcePermissionsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/{resourceID}][%d] getResourcePermissionsOk %s", 200, payload)
}

func (o *GetResourcePermissionsOK) GetPayload() []*models.ResourcePermissionDTO {
	return o.Payload
}

func (o *GetResourcePermissionsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetResourcePermissionsForbidden creates a GetResourcePermissionsForbidden with default headers values
func NewGetResourcePermissionsForbidden() *GetResourcePermissionsForbidden {
	return &GetResourcePermissionsForbidden{}
}

/*
GetResourcePermissionsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetResourcePermissionsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get resource permissions forbidden response has a 2xx status code
func (o *GetResourcePermissionsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get resource permissions forbidden response has a 3xx status code
func (o *GetResourcePermissionsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get resource permissions forbidden response has a 4xx status code
func (o *GetResourcePermissionsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get resource permissions forbidden response has a 5xx status code
func (o *GetResourcePermissionsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get resource permissions forbidden response a status code equal to that given
func (o *GetResourcePermissionsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get resource permissions forbidden response
func (o *GetResourcePermissionsForbidden) Code() int {
	return 403
}

func (o *GetResourcePermissionsForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/{resourceID}][%d] getResourcePermissionsForbidden %s", 403, payload)
}

func (o *GetResourcePermissionsForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/{resourceID}][%d] getResourcePermissionsForbidden %s", 403, payload)
}

func (o *GetResourcePermissionsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetResourcePermissionsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetResourcePermissionsNotFound creates a GetResourcePermissionsNotFound with default headers values
func NewGetResourcePermissionsNotFound() *GetResourcePermissionsNotFound {
	return &GetResourcePermissionsNotFound{}
}

/*
GetResourcePermissionsNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type GetResourcePermissionsNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get resource permissions not found response has a 2xx status code
func (o *GetResourcePermissionsNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get resource permissions not found response has a 3xx status code
func (o *GetResourcePermissionsNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get resource permissions not found response has a 4xx status code
func (o *GetResourcePermissionsNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this get resource permissions not found response has a 5xx status code
func (o *GetResourcePermissionsNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this get resource permissions not found response a status code equal to that given
func (o *GetResourcePermissionsNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the get resource permissions not found response
func (o *GetResourcePermissionsNotFound) Code() int {
	return 404
}

func (o *GetResourcePermissionsNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/{resourceID}][%d] getResourcePermissionsNotFound %s", 404, payload)
}

func (o *GetResourcePermissionsNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/{resourceID}][%d] getResourcePermissionsNotFound %s", 404, payload)
}

func (o *GetResourcePermissionsNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetResourcePermissionsNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetResourcePermissionsInternalServerError creates a GetResourcePermissionsInternalServerError with default headers values
func NewGetResourcePermissionsInternalServerError() *GetResourcePermissionsInternalServerError {
	return &GetResourcePermissionsInternalServerError{}
}

/*
GetResourcePermissionsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetResourcePermissionsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get resource permissions internal server error response has a 2xx status code
func (o *GetResourcePermissionsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get resource permissions internal server error response has a 3xx status code
func (o *GetResourcePermissionsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get resource permissions internal server error response has a 4xx status code
func (o *GetResourcePermissionsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get resource permissions internal server error response has a 5xx status code
func (o *GetResourcePermissionsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get resource permissions internal server error response a status code equal to that given
func (o *GetResourcePermissionsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get resource permissions internal server error response
func (o *GetResourcePermissionsInternalServerError) Code() int {
	return 500
}

func (o *GetResourcePermissionsInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/{resourceID}][%d] getResourcePermissionsInternalServerError %s", 500, payload)
}

func (o *GetResourcePermissionsInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/{resource}/{resourceID}][%d] getResourcePermissionsInternalServerError %s", 500, payload)
}

func (o *GetResourcePermissionsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetResourcePermissionsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
