// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// ListUserRolesReader is a Reader for the ListUserRoles structure.
type ListUserRolesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListUserRolesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListUserRolesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewListUserRolesBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewListUserRolesForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewListUserRolesInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /access-control/users/{userId}/roles] listUserRoles", response, response.Code())
	}
}

// NewListUserRolesOK creates a ListUserRolesOK with default headers values
func NewListUserRolesOK() *ListUserRolesOK {
	return &ListUserRolesOK{}
}

/*
ListUserRolesOK describes a response with status code 200, with default header values.

(empty)
*/
type ListUserRolesOK struct {
	Payload []*models.RoleDTO
}

// IsSuccess returns true when this list user roles Ok response has a 2xx status code
func (o *ListUserRolesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list user roles Ok response has a 3xx status code
func (o *ListUserRolesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list user roles Ok response has a 4xx status code
func (o *ListUserRolesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list user roles Ok response has a 5xx status code
func (o *ListUserRolesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list user roles Ok response a status code equal to that given
func (o *ListUserRolesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list user roles Ok response
func (o *ListUserRolesOK) Code() int {
	return 200
}

func (o *ListUserRolesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/users/{userId}/roles][%d] listUserRolesOk %s", 200, payload)
}

func (o *ListUserRolesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/users/{userId}/roles][%d] listUserRolesOk %s", 200, payload)
}

func (o *ListUserRolesOK) GetPayload() []*models.RoleDTO {
	return o.Payload
}

func (o *ListUserRolesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListUserRolesBadRequest creates a ListUserRolesBadRequest with default headers values
func NewListUserRolesBadRequest() *ListUserRolesBadRequest {
	return &ListUserRolesBadRequest{}
}

/*
ListUserRolesBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type ListUserRolesBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list user roles bad request response has a 2xx status code
func (o *ListUserRolesBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list user roles bad request response has a 3xx status code
func (o *ListUserRolesBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list user roles bad request response has a 4xx status code
func (o *ListUserRolesBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this list user roles bad request response has a 5xx status code
func (o *ListUserRolesBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this list user roles bad request response a status code equal to that given
func (o *ListUserRolesBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the list user roles bad request response
func (o *ListUserRolesBadRequest) Code() int {
	return 400
}

func (o *ListUserRolesBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/users/{userId}/roles][%d] listUserRolesBadRequest %s", 400, payload)
}

func (o *ListUserRolesBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/users/{userId}/roles][%d] listUserRolesBadRequest %s", 400, payload)
}

func (o *ListUserRolesBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListUserRolesBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListUserRolesForbidden creates a ListUserRolesForbidden with default headers values
func NewListUserRolesForbidden() *ListUserRolesForbidden {
	return &ListUserRolesForbidden{}
}

/*
ListUserRolesForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type ListUserRolesForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list user roles forbidden response has a 2xx status code
func (o *ListUserRolesForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list user roles forbidden response has a 3xx status code
func (o *ListUserRolesForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list user roles forbidden response has a 4xx status code
func (o *ListUserRolesForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this list user roles forbidden response has a 5xx status code
func (o *ListUserRolesForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this list user roles forbidden response a status code equal to that given
func (o *ListUserRolesForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the list user roles forbidden response
func (o *ListUserRolesForbidden) Code() int {
	return 403
}

func (o *ListUserRolesForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/users/{userId}/roles][%d] listUserRolesForbidden %s", 403, payload)
}

func (o *ListUserRolesForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/users/{userId}/roles][%d] listUserRolesForbidden %s", 403, payload)
}

func (o *ListUserRolesForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListUserRolesForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListUserRolesInternalServerError creates a ListUserRolesInternalServerError with default headers values
func NewListUserRolesInternalServerError() *ListUserRolesInternalServerError {
	return &ListUserRolesInternalServerError{}
}

/*
ListUserRolesInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type ListUserRolesInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this list user roles internal server error response has a 2xx status code
func (o *ListUserRolesInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this list user roles internal server error response has a 3xx status code
func (o *ListUserRolesInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list user roles internal server error response has a 4xx status code
func (o *ListUserRolesInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this list user roles internal server error response has a 5xx status code
func (o *ListUserRolesInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this list user roles internal server error response a status code equal to that given
func (o *ListUserRolesInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the list user roles internal server error response
func (o *ListUserRolesInternalServerError) Code() int {
	return 500
}

func (o *ListUserRolesInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/users/{userId}/roles][%d] listUserRolesInternalServerError %s", 500, payload)
}

func (o *ListUserRolesInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /access-control/users/{userId}/roles][%d] listUserRolesInternalServerError %s", 500, payload)
}

func (o *ListUserRolesInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ListUserRolesInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
