// Code generated by go-swagger; DO NOT EDIT.

package access_control

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewRemoveUserRoleParams creates a new RemoveUserRoleParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRemoveUserRoleParams() *RemoveUserRoleParams {
	return &RemoveUserRoleParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRemoveUserRoleParamsWithTimeout creates a new RemoveUserRoleParams object
// with the ability to set a timeout on a request.
func NewRemoveUserRoleParamsWithTimeout(timeout time.Duration) *RemoveUserRoleParams {
	return &RemoveUserRoleParams{
		timeout: timeout,
	}
}

// NewRemoveUserRoleParamsWithContext creates a new RemoveUserRoleParams object
// with the ability to set a context for a request.
func NewRemoveUserRoleParamsWithContext(ctx context.Context) *RemoveUserRoleParams {
	return &RemoveUserRoleParams{
		Context: ctx,
	}
}

// NewRemoveUserRoleParamsWithHTTPClient creates a new RemoveUserRoleParams object
// with the ability to set a custom HTTPClient for a request.
func NewRemoveUserRoleParamsWithHTTPClient(client *http.Client) *RemoveUserRoleParams {
	return &RemoveUserRoleParams{
		HTTPClient: client,
	}
}

/*
RemoveUserRoleParams contains all the parameters to send to the API endpoint

	for the remove user role operation.

	Typically these are written to a http.Request.
*/
type RemoveUserRoleParams struct {

	/* Global.

	   A flag indicating if the assignment is global or not. If set to false, the default org ID of the authenticated user will be used from the request to remove assignment.
	*/
	Global *bool

	// RoleUID.
	RoleUID string

	// UserID.
	//
	// Format: int64
	UserID int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the remove user role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RemoveUserRoleParams) WithDefaults() *RemoveUserRoleParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the remove user role params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RemoveUserRoleParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the remove user role params
func (o *RemoveUserRoleParams) WithTimeout(timeout time.Duration) *RemoveUserRoleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the remove user role params
func (o *RemoveUserRoleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the remove user role params
func (o *RemoveUserRoleParams) WithContext(ctx context.Context) *RemoveUserRoleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the remove user role params
func (o *RemoveUserRoleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the remove user role params
func (o *RemoveUserRoleParams) WithHTTPClient(client *http.Client) *RemoveUserRoleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the remove user role params
func (o *RemoveUserRoleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithGlobal adds the global to the remove user role params
func (o *RemoveUserRoleParams) WithGlobal(global *bool) *RemoveUserRoleParams {
	o.SetGlobal(global)
	return o
}

// SetGlobal adds the global to the remove user role params
func (o *RemoveUserRoleParams) SetGlobal(global *bool) {
	o.Global = global
}

// WithRoleUID adds the roleUID to the remove user role params
func (o *RemoveUserRoleParams) WithRoleUID(roleUID string) *RemoveUserRoleParams {
	o.SetRoleUID(roleUID)
	return o
}

// SetRoleUID adds the roleUid to the remove user role params
func (o *RemoveUserRoleParams) SetRoleUID(roleUID string) {
	o.RoleUID = roleUID
}

// WithUserID adds the userID to the remove user role params
func (o *RemoveUserRoleParams) WithUserID(userID int64) *RemoveUserRoleParams {
	o.SetUserID(userID)
	return o
}

// SetUserID adds the userId to the remove user role params
func (o *RemoveUserRoleParams) SetUserID(userID int64) {
	o.UserID = userID
}

// WriteToRequest writes these params to a swagger request
func (o *RemoveUserRoleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Global != nil {

		// query param global
		var qrGlobal bool

		if o.Global != nil {
			qrGlobal = *o.Global
		}
		qGlobal := swag.FormatBool(qrGlobal)
		if qGlobal != "" {

			if err := r.SetQueryParam("global", qGlobal); err != nil {
				return err
			}
		}
	}

	// path param roleUID
	if err := r.SetPathParam("roleUID", o.RoleUID); err != nil {
		return err
	}

	// path param userId
	if err := r.SetPathParam("userId", swag.FormatInt64(o.UserID)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
