// Code generated by go-swagger; DO NOT EDIT.

package admin_ldap

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// ReloadLDAPCfgReader is a Reader for the ReloadLDAPCfg structure.
type ReloadLDAPCfgReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ReloadLDAPCfgReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewReloadLDAPCfgOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewReloadLDAPCfgUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewReloadLDAPCfgForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewReloadLDAPCfgInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /admin/ldap/reload] reloadLDAPCfg", response, response.Code())
	}
}

// NewReloadLDAPCfgOK creates a ReloadLDAPCfgOK with default headers values
func NewReloadLDAPCfgOK() *ReloadLDAPCfgOK {
	return &ReloadLDAPCfgOK{}
}

/*
ReloadLDAPCfgOK describes a response with status code 200, with default header values.

An OKResponse is returned if the request was successful.
*/
type ReloadLDAPCfgOK struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this reload Ldap cfg Ok response has a 2xx status code
func (o *ReloadLDAPCfgOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this reload Ldap cfg Ok response has a 3xx status code
func (o *ReloadLDAPCfgOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this reload Ldap cfg Ok response has a 4xx status code
func (o *ReloadLDAPCfgOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this reload Ldap cfg Ok response has a 5xx status code
func (o *ReloadLDAPCfgOK) IsServerError() bool {
	return false
}

// IsCode returns true when this reload Ldap cfg Ok response a status code equal to that given
func (o *ReloadLDAPCfgOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the reload Ldap cfg Ok response
func (o *ReloadLDAPCfgOK) Code() int {
	return 200
}

func (o *ReloadLDAPCfgOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /admin/ldap/reload][%d] reloadLdapCfgOk %s", 200, payload)
}

func (o *ReloadLDAPCfgOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /admin/ldap/reload][%d] reloadLdapCfgOk %s", 200, payload)
}

func (o *ReloadLDAPCfgOK) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *ReloadLDAPCfgOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReloadLDAPCfgUnauthorized creates a ReloadLDAPCfgUnauthorized with default headers values
func NewReloadLDAPCfgUnauthorized() *ReloadLDAPCfgUnauthorized {
	return &ReloadLDAPCfgUnauthorized{}
}

/*
ReloadLDAPCfgUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type ReloadLDAPCfgUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this reload Ldap cfg unauthorized response has a 2xx status code
func (o *ReloadLDAPCfgUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this reload Ldap cfg unauthorized response has a 3xx status code
func (o *ReloadLDAPCfgUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this reload Ldap cfg unauthorized response has a 4xx status code
func (o *ReloadLDAPCfgUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this reload Ldap cfg unauthorized response has a 5xx status code
func (o *ReloadLDAPCfgUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this reload Ldap cfg unauthorized response a status code equal to that given
func (o *ReloadLDAPCfgUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the reload Ldap cfg unauthorized response
func (o *ReloadLDAPCfgUnauthorized) Code() int {
	return 401
}

func (o *ReloadLDAPCfgUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /admin/ldap/reload][%d] reloadLdapCfgUnauthorized %s", 401, payload)
}

func (o *ReloadLDAPCfgUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /admin/ldap/reload][%d] reloadLdapCfgUnauthorized %s", 401, payload)
}

func (o *ReloadLDAPCfgUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ReloadLDAPCfgUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReloadLDAPCfgForbidden creates a ReloadLDAPCfgForbidden with default headers values
func NewReloadLDAPCfgForbidden() *ReloadLDAPCfgForbidden {
	return &ReloadLDAPCfgForbidden{}
}

/*
ReloadLDAPCfgForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type ReloadLDAPCfgForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this reload Ldap cfg forbidden response has a 2xx status code
func (o *ReloadLDAPCfgForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this reload Ldap cfg forbidden response has a 3xx status code
func (o *ReloadLDAPCfgForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this reload Ldap cfg forbidden response has a 4xx status code
func (o *ReloadLDAPCfgForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this reload Ldap cfg forbidden response has a 5xx status code
func (o *ReloadLDAPCfgForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this reload Ldap cfg forbidden response a status code equal to that given
func (o *ReloadLDAPCfgForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the reload Ldap cfg forbidden response
func (o *ReloadLDAPCfgForbidden) Code() int {
	return 403
}

func (o *ReloadLDAPCfgForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /admin/ldap/reload][%d] reloadLdapCfgForbidden %s", 403, payload)
}

func (o *ReloadLDAPCfgForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /admin/ldap/reload][%d] reloadLdapCfgForbidden %s", 403, payload)
}

func (o *ReloadLDAPCfgForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ReloadLDAPCfgForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewReloadLDAPCfgInternalServerError creates a ReloadLDAPCfgInternalServerError with default headers values
func NewReloadLDAPCfgInternalServerError() *ReloadLDAPCfgInternalServerError {
	return &ReloadLDAPCfgInternalServerError{}
}

/*
ReloadLDAPCfgInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type ReloadLDAPCfgInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this reload Ldap cfg internal server error response has a 2xx status code
func (o *ReloadLDAPCfgInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this reload Ldap cfg internal server error response has a 3xx status code
func (o *ReloadLDAPCfgInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this reload Ldap cfg internal server error response has a 4xx status code
func (o *ReloadLDAPCfgInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this reload Ldap cfg internal server error response has a 5xx status code
func (o *ReloadLDAPCfgInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this reload Ldap cfg internal server error response a status code equal to that given
func (o *ReloadLDAPCfgInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the reload Ldap cfg internal server error response
func (o *ReloadLDAPCfgInternalServerError) Code() int {
	return 500
}

func (o *ReloadLDAPCfgInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /admin/ldap/reload][%d] reloadLdapCfgInternalServerError %s", 500, payload)
}

func (o *ReloadLDAPCfgInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /admin/ldap/reload][%d] reloadLdapCfgInternalServerError %s", 500, payload)
}

func (o *ReloadLDAPCfgInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *ReloadLDAPCfgInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
